% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_priorsense_data.R
\name{create-priorsense-data}
\alias{create-priorsense-data}
\alias{create_priorsense_data}
\alias{create_priorsense_data.default}
\alias{create_priorsense_data.stanfit}
\alias{create_priorsense_data.CmdStanFit}
\alias{create_priorsense_data.draws}
\title{Create data structure for priorsense}
\usage{
create_priorsense_data(x, ...)

\method{create_priorsense_data}{default}(
  x,
  fit = NULL,
  log_prior_fn = log_prior_draws,
  log_lik_fn = log_lik_draws,
  log_prior = NULL,
  log_lik = NULL,
  log_ratio_fn = NULL,
  ...
)

\method{create_priorsense_data}{stanfit}(x, ...)

\method{create_priorsense_data}{CmdStanFit}(x, ...)

\method{create_priorsense_data}{draws}(x, ...)
}
\arguments{
\item{x}{an object for which the method is defined}

\item{...}{arguments passed to methods}

\item{fit}{a model fit object (only used if x is not a fit object)}

\item{log_prior_fn}{function to derive log prior from object}

\item{log_lik_fn}{function to derive log likelihood from object}

\item{log_prior}{draws from log prior}

\item{log_lik}{draws from log likelihood}

\item{log_ratio_fn}{function for moment matching}
}
\value{
A \code{priorsense_data} object, which contains the data and
functions to run sensitivity analyses.
}
\description{
Create a data structure that contains all required data and
functions for priorsense
}
\examples{
x <- example_powerscale_model()
drw <- x$draws

psd <- create_priorsense_data(drw)
}
