% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate_cost}
\alias{simulate_cost}
\title{Simulate cost data}
\usage{
simulate_cost(x, n = 1, intensity = 100, sd = 20, scale = 2.5)
}
\arguments{
\item{x}{\code{\link[raster:raster]{raster::raster()}} raster object to use as a template.}

\item{n}{\code{integer} number of layers to simulate.
Defaults to 1.}

\item{intensity}{\code{numeric} average value of simulated data.
Defaults to 100.}

\item{sd}{\code{numeric} standard deviation of simulated data.
Defaults to 20.}

\item{scale}{\code{numeric} strength of spatial auto-correlation.
Defaults to 2.5.}
}
\value{
\code{\linkS4class{RasterStack}} object.
}
\description{
Generates simulated cost data using Gaussian random fields.
Specifically, it returns spatially auto-correlated data with integer values.
}
\examples{
\dontrun{
# create raster
r <- raster(ncol = 10, nrow = 10, xmn = 0, xmx = 1, ymn = 0, ymx = 1)
values(r) <- 1

# simulate data
cost <- simulate_cost(r)

# plot simulated species
plot(cost, main = "simulated cost data")
}

}
\seealso{
\code{\link[=simulate_data]{simulate_data()}}.
}
