% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rij_matrix.R
\name{rij_matrix}
\alias{rij_matrix}
\alias{rij_matrix,Raster,Raster-method}
\alias{rij_matrix,Spatial,Raster-method}
\alias{rij_matrix,sf,Raster-method}
\title{Feature by planning unit matrix}
\usage{
rij_matrix(x, y, ...)

\S4method{rij_matrix}{Raster,Raster}(x, y, ...)

\S4method{rij_matrix}{Spatial,Raster}(x, y, fun, ...)

\S4method{rij_matrix}{sf,Raster}(x, y, fun, ...)
}
\arguments{
\item{x}{\code{\linkS4class{Raster}},
\code{\linkS4class{Spatial}}, or \code{\link[sf:sf]{sf::sf()}} object
representing the planning units.}

\item{y}{\code{\linkS4class{Raster}} object representing the
features.}

\item{...}{not used.}

\item{fun}{\code{character} for summarizing values inside each planning unit.
This parameter is only used when the argument to \code{x} is a
\code{\linkS4class{Spatial}} or \code{\link[sf:sf]{sf::sf()}} object.
Defaults to \code{"sum"}.}
}
\value{
\code{\linkS4class{dgCMatrix}} sparse matrix object.
The sparse matrix represents the spatial intersection between the
planning units and the features. Rows correspond to features,
and columns correspond to planning units. Values correspond to the amount
(or presence/absence) of the feature in the planning unit. For example,
the amount of the third species in the second planning unit would be
stored in the third column and second row.
}
\description{
Generate a matrix showing the amount of each feature in each planning
unit (also known as an \emph{rij} matrix).
}
\details{
Generally, processing vector (i.e., \code{\linkS4class{Spatial}} or
\code{\link[sf:sf]{sf::sf()}}) data takes much
longer to process then \code{\linkS4class{Raster}} data,
so it is recommended to use \code{\linkS4class{Raster}} data
for planning units where possible.
}
\examples{
\dontrun{
# load data
data(sim_pu_raster, sim_pu_polygons, sim_pu_sf, sim_pu_zones_stack)

# create rij matrix using raster layer planning units
rij_raster <- rij_matrix(sim_pu_raster, sim_features)
print(rij_raster)

# create rij matrix using polygon (Spatial) planning units
rij_polygons <- rij_matrix(sim_pu_polygons, sim_features)
print(rij_polygons)

# create rij matrix using polygon (sf) planning units
rij_sf <- rij_matrix(sim_pu_sf, sim_features)
print(rij_sf)

# create rij matrix using raster stack planning units
rij_zones_raster <- rij_matrix(sim_pu_zones_stack, sim_features)
print(rij_zones_raster)
}
}
