% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adjust_for_inflation.R
\name{url_all_results}
\alias{url_all_results}
\title{Generate a World Bank API URL that will return all results for a given indicator in JSON format}
\usage{
url_all_results(original_url)
}
\arguments{
\item{original_url}{A World Bank API URL. E.g. "http://api.worldbank.org/v2/country".}
}
\value{
A character vector
}
\description{
results and returns JSON format
}
\examples{

# Provide a World Bank API URL and `url_all_results` will convert it into one with all results
# for that indicator
\dontrun{
  original_url <- "http://api.worldbank.org/v2/country" # Note: no ?format=json on url
  url_all_results(original_url)
}
# "http://api.worldbank.org/v2/country?format=json&per_page=304"



}
