% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format.R
\name{format_dollars}
\alias{format_dollars}
\title{Make numeric currency values human readable}
\usage{
format_dollars(amount, digits)
}
\arguments{
\item{amount}{Price or vector of prices (character, numeric, or integer)}

\item{digits}{The number of decimal places. Set equal to 2 to include cents (defaults to 0 i.e. whole dollars)}
}
\value{
A character vector
}
\description{
Make numeric currency values human readable
}
\examples{

format_dollars("2423562534234")
# "$2,423,562,534,234"

format_dollars("2423562534234.876", 0)
# "$2,423,562,534,234"

format_dollars("2423562534234.876", 2)
# "$2,423,562,534,234.88"

format_dollars("2423562534234", 2)
# "$2,423,562,534,234.00"
}
