% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/correlation_measures.R
\name{prec_icc}
\alias{prec_icc}
\title{Sample size or precision for an intraclass correlation}
\usage{
prec_icc(rho, k, n = NULL, conf.width = NULL, conf.level = 0.95)
}
\arguments{
\item{rho}{desired intraclass correlation.}

\item{k}{number of observations per n (subject).}

\item{n}{number of subjects.}

\item{conf.width}{precision (the full width of the confidence interval).}

\item{conf.level}{confidence level.}
}
\value{
Object of class "presize", a list of arguments (including the
  computed one) augmented with method and note elements.
}
\description{
\code{prec_icc} returns the sample size or the precision for the given
intraclass correlation.
}
\details{
Exactly one of the parameters \code{n} or \code{conf.width} must be passed as NULL,
and that parameter is determined from the others.

Sample size or precision is calculated according to formula 3 in Bonett
(2002), which is an approximation. Whether ICC is calculated for a one-way or
a two-way ANOVA does not matter in the approximation. As suggested by the
author, \eqn{5*rho} is added to n, if \eqn{k = 2} and \eqn{rho \ge 7}.

n is rounded up to the next whole number using \code{ceiling}.
}
\examples{
# Bonett (2002) gives an example using 4 raters, with an ICC of 0.85 and want
# a confidence width of 0.2. Bonett calculated that a sample size of 19.2 was
# required. This can be done via
prec_icc(0.85, 4, conf.width = 0.2)
# note that \code{presamp} rounds up to the nearist integer.

# Bonett then goes on to estimate the width given the sample size, finding a
# value 'close to 0.2':
prec_icc(0.85, 4, 20)
}
\references{
Bonett DG (2002). \emph{Sample size requirements for estimating
  intraclass correlations with desired precision}. Statistics in Medicine,
  21:1331-1335. \href{https://doi.org/10.1002/sim.1108}{doi:10.1002/sim.1108}
}
