% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_spec_to_html.R
\name{prereg_spec_to_html}
\alias{prereg_spec_to_html}
\title{Convert a (pre)registration specification to html}
\usage{
prereg_spec_to_html(
  x,
  file = NULL,
  section = NULL,
  headingLevel = 1,
  silent = preregr::opts$get("silent")
)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{file}{Optionally, a file to save the html to.}

\item{section}{Optionally, one or multiple sections to include (if \code{NULL},
all sections are included).}

\item{headingLevel}{The level of the top-most headings.}

\item{silent}{Whether to be silent or chatty.}
}
\value{
x, invisibly
}
\description{
Convert a (pre)registration specification to html
}
\examples{
preregr::prereg_initialize(
  "inclSysRev_v0_92"
) |>
  preregr::prereg_specify(
    title = "Example Study",
    authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
    nonExistent_item = "This can't be stored anywhere"
  ) |>
  preregr::prereg_justify(
    item = "primary_research_question",
    content = "Example content",
    decision = "decision ...",
    justification = "justification ..."
  ) |>
  preregr::prereg_spec_to_html();
}
