% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prereg_show_item_content.R
\name{prereg_show_item_content}
\alias{prereg_show_item_content}
\title{Show the specified content for the items in a (pre)registration}
\usage{
prereg_show_item_content(x, section = NULL)
}
\arguments{
\item{x}{The (pre)registration object (as produced by a call to
\code{\link[=prereg_initialize]{prereg_initialize()}}).}

\item{section}{The section(s) to show; pass \code{NULL} (the default) to show
everything.}
}
\value{
x, invisibly
}
\description{
This function shows the specified content for the items in a
(pre)registration, or in one or more sections.
}
\examples{
examplePreReg <-
  preregr::prereg_initialize(
    "inclSysRev_v0_92"
  ) |>
    preregr::prereg_specify(
      title = "Example Study",
      authors = "Littlebottom, C., Dibbler, C., & Aching, T.",
      nonExistent_item = "This can't be stored anywhere"
    ) |>
    prereg_show_item_content(
      section="metadata"
    );
}
