% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/03BaseClass.R
\name{prc}
\alias{prc}
\title{prc}
\usage{
prc(classname, dataobject, model = "knn", nholdout = 2, nsharehopkins = 3,
  klof = 5)
}
\arguments{
\item{classname}{(character) name of preprocessor (i.e. PreprocessorClass sub class as defined by setpreprocessor())}

\item{dataobject}{(sub class/ data frame/ DataClass) object}

\item{model}{(character) caret model name, note: the required model library must be attached, defaults to "knn"}

\item{nholdout}{(integer) number of holdout rounds used in computation of classification accuracy, must be two or more, defaults to two}

\item{nsharehopkins}{(integer) denominator for sample size for hopkins statistics, defauls to three  (n=nrow(data)/3)}

\item{klof}{(integer) number of data points used for neighborhood in LOF algorithm, defaults to five}
}
\value{
object of PreprocessorClass sub class
}
\description{
prc is the main function for interactive use. It takes data, transforms it according to the given
preprocessor and computes statistics of the transformed data. The main use case is the chaining of
the preprocessors as show in the examples below.
}
\examples{
## a <- prc("scale", iris)
## b <- prc("rfselect75", a)
## d <- prc("scale", iris, "rf", 20, 2, 10)
}

