% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibPlot.R
\name{calibration_plot}
\alias{calibration_plot}
\title{Title Create calibration plot based on observed and predicted outcomes.}
\usage{
calibration_plot(
  data,
  obs,
  follow_up = NULL,
  pred,
  group = NULL,
  nTiles = 10,
  legendPosition = "right",
  title = NULL,
  x_lim = NULL,
  y_lim = NULL,
  xlab = "Prediction",
  ylab = "Observation",
  points_col_list = NULL,
  data_summary = FALSE
)
}
\arguments{
\item{data}{Data include observed and predicted outcomes.}

\item{obs}{Name of observed outcome in the input data.}

\item{follow_up}{Name of follow-up time (if applicable) in the input data.}

\item{pred}{Name of first predicted outcome in the input data.}

\item{group}{Name of grouping column (if  applicable) in the input data.}

\item{nTiles}{Number of tiles (e.g., 10 for deciles) in the calibration plot.}

\item{legendPosition}{Legend position on the calibration plot.}

\item{title}{Title on the calibration plot.}

\item{x_lim}{Limits of x-axis on the calibration plot.}

\item{y_lim}{Limits of y-axis on the calibration plot.}

\item{xlab}{Label of x-axis on the calibration plot.}

\item{ylab}{Label of y-axis on the calibration plot.}

\item{points_col_list}{Points' color on the calibration plot.}

\item{data_summary}{Logical indicates whether a summary of the predicted and observed outcomes.
needs to be included in the output.}
}
\value{
Returns calibration plot (a ggplot object) and a dataset including summary statistics of
the predicted and observed outcomes (if data_summary set to be TRUE).
}
\description{
Title Create calibration plot based on observed and predicted outcomes.
}
\examples{
library(predtools)
library(dplyr)
x <- rnorm(100, 10, 2)
y <- x + rnorm(100,0, 1)
data <- data.frame(x, y)
calibration_plot(data, obs = "x", pred = "y")
}
