#!/usr/bin/env Rscript

files <- commandArgs(trailing = TRUE)
no_browser_statement <- function(path) {
  pd <- getParseData(parse(path, keep.source = TRUE))
  if (any(pd$text[pd$token == "SYMBOL_FUNCTION_CALL"] == "browser")) {
    stop("File `", path, "` contains a `browser()` statement.", call. = FALSE)
  }
}

for (file in files) {
  temp <- no_browser_statement(file)
}
