% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CATE_continuous.R
\name{scoremean}
\alias{scoremean}
\title{Calculate the CATE score given the baseline covariates for specified scoring method methods}
\usage{
scoremean(
  fit,
  x.cate,
  score.method = c("boosting", "gaussian", "twoReg", "contrastReg", "randomForest",
    "gam")
)
}
\arguments{
\item{fit}{List of objects generated from intxmean: outputs of boosting, linear regression, two regression, contrast regression, random forest, generalized additive model}

\item{x.cate}{Matrix of \code{p.cate} baseline covariates; dimension \code{n} (observations) by \code{p.cate} (covariates in the outcome model)}

\item{score.method}{A vector of one or multiple methods to estimate the CATE score.
Allowed values are: \code{'boosting'}, \code{'gaussian'}, \code{'twoReg'}, \code{'contrastReg'}, \code{'randomForest'}, \code{'gam'}.
Default specifies all 6 methods.}
}
\value{
score.boosting: Estimated CATE score for all \code{n} observations with the boosting method; vector of size \code{n}
        score.gaussian: Estimated CATE score for all \code{n} observations with the linear regression method; vector of size \code{n}
        score.twoReg: Estimated CATE score for all \code{n} observations with the two regression method; vector of size \code{n}
        score.contrastReg: Estimated CATE score for all \code{n} observations with the contrast regression method; vector of size \code{n}
        score.randomForest: Estimated CATE score for all \code{n} observations with the random forest method; vector of size \code{n}
        score.gam: Estimated CATE score for all \code{n} observations with the generalized additive model; vector of size \code{n}
        score = NA if the corresponding method is not called
}
\description{
Based on intxmean results of the CATE coefficients estimated with boosting, linear regression, two regression, contrast regression, random forest, generalized additive model
}
