% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_zzz.R
\docType{class}
\name{TestDataB}
\alias{TestDataB}
\title{R6 class of test dataset for performance evaluation tools}
\format{An R6 class object.}
\usage{
TestDataB
}
\description{
\code{TestDataB} is a class that contains scores and label for performance
  evaluation tools. It provides necessary methods for benchmarking.
}
\section{Methods}{

\itemize{
 \item \code{get_tsname()}: Get the dataset name.
 \item \code{get_scores()}: Get a vector of scores.
 \item \code{get_labels()}: Get a vector of labels.
 \item \code{get_fg()}: Get a vector of positive scores.
 \item \code{get_bg()}: Get a vector of negative scores.
 \item \code{get_fname()}: Get a file name that contains scores and labels.
 \item \code{del_file()}: Delete the file with scores and labels.
}
}
\examples{
## Initialize with scores, labels, and a dataset name
testset <- TestDataB$new(c(0.1, 0.2, 0.3), c(0, 1, 1), "m1")
testset

}
\seealso{
\code{\link{create_testset}} for creating a list of test datasets.
  \code{\link{TestDataC}} is derived from this class for curve evaluation.
}
\keyword{datasets}

