% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/g_autoplot.R
\name{autoplot.evalcurve}
\alias{autoplot.evalcurve}
\title{Plot the result of Precision-Recall curve evaluation}
\usage{
\method{autoplot}{evalcurve}(object, base_plot = TRUE, ret_grob = FALSE,
  ncol = NULL, nrow = NULL, use_category = FALSE, ...)
}
\arguments{
\item{object}{An S3 object that contains evaluation results of
Precision-Recall curves.}

\item{base_plot}{A Boolean value to specify whether the base points are
plotted.}

\item{ret_grob}{A Boolean value to specify whether the function returns a
grob object.}

\item{ncol}{An integer used for the column size of multiple panes.}

\item{nrow}{An integer used for the row size of multiple panes.}

\item{use_category}{A Boolean value to specify whether the categorical
summary instead of the total summary.}

\item{...}{Not used by this function.}
}
\value{
A data frame with validation results.
}
\description{
The \code{plot_eval_results} function validates Precision-Recall curves
   and creates a plot.
}
\examples{
library(ggplot2)

## Plot evaluation results on test datasets r1, r2, and r3
testset <- create_testset("curve", c("c1", "c2", "c3"))
toolset <- create_toolset(set_names = "crv5")
eres1 <- run_evalcurve(testset, toolset)
autoplot(eres1)

}

