% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.prais.R, R/print.summary.prais.R
\name{summary.prais}
\alias{summary.prais}
\alias{print.summary.prais}
\title{Summarising the Prais-Winsten Estimator}
\usage{
\method{summary}{prais}(object, ...)

\method{print}{summary.prais}(x, digits = max(3L, getOption("digits") - 3L),
  signif.stars = getOption("show.signif.stars"), ...)
}
\arguments{
\item{object}{an object of class "prais", usually, a result of a call to \code{\link{prais_winsten}}.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "summary.prais", usually, a result of a call to \code{\link{summary.prais}}.}

\item{digits}{the number of significant digits to use when printing.}

\item{signif.stars}{logical. If \code{TRUE}, 'significance stars' are printed for each coefficient.}
}
\value{
\code{summary.prais} returns a list of class "summary.prais", which contains the following components:
\item{call}{the matched call.}
\item{residuals}{the residuals, that is the response minus the fitted values.}
\item{coefficients}{a named vector of coefficients.}
\item{rho}{the values of the AR(1) coefficient \eqn{\rho} from all iterations.}
\item{sigma}{the square root of the estimated variance of the random error.}
\item{df}{degrees of freedom, a 3-vector \emph{(p, n-p, p*)}, the first being the number of non-aliased coefficients, the last being the total number of coefficients.}
\item{r.squared}{R^2, the 'fraction of variance explained by the model',
\deqn{R^2 = 1 - Sum(R[i]^2) / Sum((y[i]- y*)^2),}
where \emph{y*} is the mean of \emph{y[i]} if there is an intercept and zero otherwise.}
\item{adj.r.squared}{the above \emph{R^2} statistic \emph{'adjusted'}, penalising for higher \emph{p}.}
\item{fstatistic}{(for models including non-intercept terms) a 3-vector with the value of the F-statistic with its numerator and denominator degrees of freedom.}
\item{cov.unscaled}{a \eqn{p x p} matrix of (unscaled) covariances of the \emph{coef[j], j=1, ..., p}.}
\item{dw}{a named 2-vector with the Durbin-Watson statistic of the original linear model and the Prais-Winsten estimator.}
}
\description{
summary method for class "prais".
}
