% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prais_winsten.R, R/print.prais.R
\name{prais_winsten}
\alias{prais_winsten}
\alias{print.prais}
\title{Prais-Winsten Estimator for AR(1) Serial Correlation}
\usage{
prais_winsten(formula, max_iter = 50L, tol = 1e-06, twostep = FALSE, ...)

\method{print}{prais}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{formula}{an object of class "formula" (or one that can be coerced to that class): a symbolic description of the model to be fitted.}

\item{max_iter}{integer specifying the maximum number of allowed iterations. Default is 50.}

\item{tol}{numeric specifying the maximum absolute difference between the estimator of rho in the current and the previous iteration that has to be attained to reach convergence. Default is 1e-6.}

\item{twostep}{logical. If \code{TRUE}, the estimation will stop after the first iteration.}

\item{...}{further arguments passed to or from other methods.}

\item{x}{an object of class "prais", usually, a result of a call to \code{\link{prais_winsten}}.}

\item{digits}{the number of significant digits to use when printing.}
}
\value{
a list of class "prais" containing the following components:
\item{coefficients}{a named vector of coefficients.}
\item{rho}{the values of the AR(1) coefficient \eqn{\rho} from all iterations.}
\item{residuals}{the residuals, that is the response minus the fitted values.}
\item{fitted.values}{the fitted mean values.}
\item{rank}{the numeric rank of the fitted linear model.}
\item{df.residual}{the residual degrees of freedom.}
\item{call}{the matched call.}
\item{model}{the original model frame, i.e., before the Prais-Winsten transformation.}
}
\description{
The Prais-Winsten estimator takes into account AR(1) serial correlation of the errors
in a linear regression model. The procedure recursively estimates the coefficients
and the error autocorrelation of the specified model until sufficient convergence of
the AR(1) coefficient is reached. All estimates are obtained by OLS.
}
\section{Methods (by generic)}{
\itemize{
\item \code{print}: 
}}

\examples{
# Generate an artificial sample
set.seed(1234567)
n <- 100
x <- sample(20:40, n, replace = TRUE)
rho <- .5
u <- rnorm(n, 0, 5)
for (i in 2:n) {
  u[i] <- u[i] + rho * u[i - 1]
}
pw_sample <- data.frame("x" = x, "y" = 10 + 1.5 * x + u)

# Estimate
pw <- prais_winsten(y ~ x, data = pw_sample)
summary(pw)

}
\references{
Prais, S. J. and Winsten, C. B. (1954): Trend Estimators and Serial Correlation. Cowles Commission Discussion Paper, 383 (Chicago).

Wooldridge, J. M. (2013): Introductory Econometrics. A Modern Approach. 5th ed. Mason, OH: South-Western Cengage Learning Cengage.
}
