% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/praatanimation.R
\name{praatanimation}
\alias{praatanimation}
\title{Make animations from Praat Picture-style plots of acoustic data}
\usage{
praatanimation(
  sound,
  width = 1080,
  height = 720,
  frameRate = 24,
  n_frames = 50,
  loop = TRUE,
  outputFile = NULL,
  outputFormat = "gif",
  useViewer = TRUE,
  verbose = TRUE,
  pointsize = 25,
  start = 0,
  end = 0,
  spec_freqRange = c(0, 5000),
  spec_windowLength = 0.005,
  spec_dynamicRange = 50,
  spec_timeStep = 1000,
  pitch_timeStep = NULL,
  pitch_floor = 50,
  pitch_ceiling = 600,
  pitch_freqRange = c(50, 500),
  pitch_semitonesRe = 100,
  formant_timeStep = NULL,
  formant_windowLength = 0.025,
  formant_dynamicRange = 30,
  formant_freqRange = c(50, 5500),
  intensity_timeStep = NULL,
  intensity_minPitch = 100,
  intensity_range = NULL,
  ...
)
}
\arguments{
\item{sound}{String giving the file name of a sound file with the .wav
extension.}

\item{width}{Number giving the desired width of the resulting animation in
pixels; default is \code{1080}.}

\item{height}{Number giving the desired height of the resulting animation in
pixels; default is \code{720}.}

\item{frameRate}{Number giving the desired frame rate of the resulting
animation in Hz; default is \code{24}, i.e. 24 frames per second.}

\item{n_frames}{Number giving the desired number of frames of the resulting
animation; default is \code{50}.}

\item{loop}{Logical; should the animation be looped? Default is \code{TRUE}.
Ignored when \code{outputType} is \code{mp4}.}

\item{outputFile}{String giving the desired file name of the animation.
Default is \code{NULL}, in which case GIF files are named \code{praatgif.gif} and
MP4 files are named \code{praatvid.mp4}. If you choose a different name, make
sure that the file extension matches the selected \code{outputType}.}

\item{outputFormat}{String giving the desired file type; default is \code{gif},
the only other option is \code{mp4}.S}

\item{useViewer}{Logical; should the animation be shown in the Viewer pane in
RStudio? Default is \code{TRUE}; if true, the animation is only saved in a
temporary directory, but can be downloaded from a browser.}

\item{verbose}{Logical; should status messages be printed in the console as
figures are being generated? Default is \code{TRUE}.}

\item{pointsize}{Number; which point size should be used for text in the
animation? Default is \code{25}. See \code{\link[grDevices:png]{grDevices::png()}} for more details.}

\item{start}{Start time (in seconds) of desired plotted area. Default is \code{0}.
Alternatively, a vector giving the first and last start time in the
animation.}

\item{end}{End time (in seconds) of desired plotted area. Default is \code{0}
(= the entire file). Alternatively, a vector giving the first and last
end time in the animation.}

\item{spec_freqRange}{Vector of two integers giving the frequency range to be
used for plotting spectrograms. Default is \code{c(0,5000)}. Alternatively, a
vector of four integers giving the first and last lowest frequency, followed
by the first and last highest frequency in the animation; i.e.,
\code{c(0,0,5000,10000)} will produce an animation where the upper frequency
boundary gradually increases from 5000 Hz to 10,000 Hz.}

\item{spec_windowLength}{Window length in seconds for generating spectrograms.
Default is \code{0.005}. Alternatively, a vector giving the first and last
window lengths in the animation.}

\item{spec_dynamicRange}{Dynamic range in dB for generating spectrograms. The
maximum intensity minus \code{spec_dynamicRange} will all be printed in white.
Default is \code{50}. Alternatively, a vector giving the first and last
dynamic range values in the animation.}

\item{spec_timeStep}{How many time steps should be calculated for spectrograms?
Default is \code{1000}. Alternatively, a vector giving the first and last
time step values in the animation.}

\item{pitch_timeStep}{Measurement interval in seconds for tracking pitch.
Default is \code{NULL}, in which case the measurement interval is equal to
0.75 / \code{pitch_floor}. Alternatively, a vector giving the first and last
measurement intervals in the animation.}

\item{pitch_floor}{Frequency in Hz; no pitch candidates considered below
this frequency. Default is \code{75}. Alternatively, a vector giving the first and
last pitch floors to be used in the animation.}

\item{pitch_ceiling}{Frequency in Hz; no pitch candidates considered above
this frequency. Default is \code{600}. Alternatively, a vector giving the first and
last pitch ceilings to be used in the animation.}

\item{pitch_freqRange}{Vector of two integers giving the frequency range to be
used for producing pitch plots. Default is \code{c(50,500)}. If the frequency
scales \code{semitones} or \code{erb} are used, the pitch range is automatically reset
to the Praat defaults for these scales (\code{c(-12,30)} and \code{c(0,10)},
respectively). Alternatively, a
vector of four integers giving the first and last lowest frequency, followed
by the first and last highest frequency in the animation
(see \code{spec_freqRange} for usage details).}

\item{pitch_semitonesRe}{Frequency in Hz giving the reference level for
converting pitch frequency to semitones. Default is \code{100}.
Alternatively, a vector giving the first and
last semitone reference levels to be used in the animation.}

\item{formant_timeStep}{Measurement interval in seconds for tracking formants.
Default is \code{NULL}, in which case the measurement interval is equal to
\code{formant_windowLength} / 4. Alternatively, a vector giving the first and
last measurement intervals to be used in the animation.}

\item{formant_windowLength}{The effective duration of the analysis window
used for tracking formants in seconds; the actual duration of the
analysis window is twice this value. Alternatively, a vector giving the first
and last window lengths to be used in the animation.}

\item{formant_dynamicRange}{Dynamic range in dB for producing formant plots.
When a formant plot of \code{formant_plotType='speckle'} is drawn, no formants are
shown in frames with intensity level \code{formant_dynamicRange} below the maximum
intensity. Default is \code{30}. If set to \code{0}, all formants are shown.
Alternatively, a vector giving the first
and last dynamic range levels to be used in the animation.}

\item{formant_freqRange}{Vector of two integers giving the frequency range to
be used for producing formant plots. Default is \code{c(0,5500)}. Alternatively, a
vector of four integers giving the first and last lowest frequency, followed
by the first and last highest frequency in the animation
(see \code{spec_freqRange} for usage details).}

\item{intensity_timeStep}{Measurement interval in seconds for tracking
intensity. Default is \code{NULL}, in which case the measurement interval is
equal to 0.8 * \code{intensity_minPitch}. Alternatively, a vector giving the first
and last measurement intervals to be used in the animation.}

\item{intensity_minPitch}{Lowest pitch in Hz used when calculating
intensity; default is \code{100}. Alternatively, a vector giving the first
and last minimum pitch levels to be used in the animation.}

\item{intensity_range}{Vector of two integers giving the intensity range to be
used for producing intensity plots. Default is \code{NULL}, in which case the
range is simply the minimum and maximum levels in the curve. Alternatively, a
vector of four integers giving the first and last lowest level, followed
by the first and last highest level in the animation
(see \code{spec_freqRange} for usage details).}

\item{...}{Further arguments passed to \code{praatpicture}.}
}
\value{
No return value, produces an animated figure.
}
\description{
Animate some aspect of a Praat Picture-style plot
of acoustic data, potentially aligned with transcriptions.
}
\examples{
\dontrun{
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')

# Show increasing frequency range
praatanimation(soundFile, spec_freqRange=c(0,0,4000,12000))

# Transition from narrowband to broadband spectrogram
praatanimation(soundFile, spec_windowLength=c(0.005,0.03))

# Etc.
}
}
\seealso{
This function is a wrapper for either \code{gifski::save_gif()}
or \code{av::av_capture_graphics()} used to
produce animations based on \code{praatpicture()}. For more detail on your
options, see the \code{praatpicture()} help file.
}
