% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waveplot.R
\name{waveplot}
\alias{waveplot}
\title{Plot waveform}
\usage{
waveplot(
  sig,
  bit,
  t,
  nchan = 1,
  color = "black",
  tgbool = FALSE,
  lines = NULL,
  focusTierColor = "black",
  focusTierLineType = "dotted",
  ind = NULL,
  line_comp = NULL,
  rect_comp = NULL,
  arr_comp = NULL,
  annot_comp = NULL,
  draw_lines = NULL,
  draw_rectangle = NULL,
  draw_arrow = NULL,
  annotate = NULL,
  channelNames = FALSE,
  lineWidth = 1,
  cn = NULL,
  min_max_only = TRUE,
  highlight = NULL
)
}
\arguments{
\item{sig}{Numeric vector corresponding to a sound signal.}

\item{bit}{Numeric; will generally be grabbed from a loaded \code{WaveMC} object.}

\item{t}{Numeric vector giving times corresponding to the signal.}

\item{nchan}{Numeric; how many channels will be plotted? Default is \code{1}.}

\item{color}{String giving the name of the color to be used for plotting
the waveform. Default is \code{'black'}. Alternatively, a vector of colors, if
different channels should be plotted with different colors.}

\item{tgbool}{Logical; should dotted lines be plotted corresponding to
locations in a TextGrid? Default is \code{FALSE}.}

\item{lines}{Numeric vector giving locations in seconds of locations from
a TextGrid to be plotted with dotted lines. Default is \code{NULL}.}

\item{focusTierColor}{String or vector of strings giving the color(s) to
use for plotting focus tier lines. If multiple tiers are focused, a vector
of the same length can be passed, and the nth tier will be plotted in the
nth color. Default is \code{'black'}.}

\item{focusTierLineType}{String or vector of strings giving the line
type(s) for plotting focus tier lines. If multiple tiers are focused, a
vector of the same length can be passed, and the nth tier will be plotted in
the nth line type. Default is \code{'dotted'}.}

\item{ind}{Integer indexing waveform relative to other plot components.
Default is \code{NULL}.}

\item{line_comp}{Vector of strings or numbers giving plot components to draw
straight lines on. Default is \code{NULL}.}

\item{rect_comp}{Vector of strings or numbers giving plot components to draw
rectangles on. Default is \code{NULL}.}

\item{arr_comp}{Vector of strings of numbers giving plot components to draw
arrows on. Default is \code{NULL}.}

\item{annot_comp}{Vector of strings of numbers giving plot components to
annotate. Default is \code{NULL}.}

\item{draw_lines}{List of arguments for drawing straight lines passed from
\code{praatpicture()}. Default is \code{NULL}.}

\item{draw_rectangle}{List of arguments for drawing rectangles passed from
\code{praatpicture()}. Default is \code{NULL}.}

\item{draw_arrow}{List of arguments for drawing arrows passed from
\code{praatpicture()}. Default is \code{NULL}.}

\item{annotate}{List of arguments for annotating passed from
\code{praatpicture()}. Default is \code{NULL}.}

\item{channelNames}{Logical; should names of audio channels be printed on
the y-axis? Default is \code{FALSE}.}

\item{lineWidth}{Number giving the line width to use for plotting
the waveform. Default is \code{1}.}

\item{cn}{Vector of strings with channel names to be printed on the y-axis
if \code{channelNames} is \code{TRUE}.}

\item{min_max_only}{Logical; should only minimum and maximum values be given
on the y-axis? Default is \code{TRUE}. Can also be a logical vector if some but
not all plot components should have minimum and maximum values on the y-axis.
Ignored for TextGrid component.}

\item{highlight}{Named list giving parameters for differential
highlighting of the waveform based on the time domain. This list
should contain information about which parts of the plot to highlight, either
done with the \code{start} and \code{end} arguments which must be numbers or numeric
vectors, or using the \code{tier} and \code{label} arguments to highlight based on
information in a plotted TextGrid. Further contains the argument
\code{color} (string, see \code{color}), and \code{background}
(a string specifying a background color).}
}
\value{
No return values, called internally by \link{praatpicture} and sibling
functions.
}
\description{
Function for plotting waveforms called by \link{praatpicture}. Instead of using
this function directly, just use
\code{praatpicture('my_sound_file', frames='sound')}.
}
\examples{
# Don't use directly
datapath <- system.file('extdata', package='praatpicture')
soundFile <- paste0(datapath, '/1.wav')
praatpicture(soundFile, frames='sound')
}
