% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/04_data.R
\docType{data}
\name{ppiNPL2013_a}
\alias{ppiNPL2013_a}
\title{Poverty Probability Index (PPI) lookup table for Nepal using new poverty
definitions}
\format{
A data frame with 9 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nlFood}}{Food poverty line}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{extreme}}{USAID extreme poverty}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp200}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiNPL2013_a
}
\description{
Poverty Probability Index (PPI) lookup table for Nepal using new poverty
definitions
}
\examples{
  # Access Nepal PPI table
  ppiNPL2013_a

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiNPL2013_a[ppiNPL2013_a$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiNPL2013_a, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiNPL2013_a[ppiNPL2013_a$score == ppiScore, "nl100"]

}
\keyword{datasets}
