% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiGHA2015}
\alias{ppiGHA2015}
\title{ppiGHA2015}
\format{A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nlFood}}{Food poverty line}
\item{\code{nl100}}{National poverty line (100\%)}
\item{\code{nl150}}{National poverty line (150\%)}
\item{\code{nl200}}{National poverty line (200\%)}
\item{\code{ppp125}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $2.75 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiGHA2015
}
\description{
Poverty Probability Index (PPI) lookup table for Ghana based on legacy
definitions
}
\examples{
  # Access Ghana PPI table
  ppiGHA2015

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiGHA2015[ppiGHA2015$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiGHA2015, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiGHA2015[ppiGHA2015$score == ppiScore, "nl100"]

}
\keyword{datasets}
