% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiBOL2015}
\alias{ppiBOL2015}
\title{ppiBOL2015}
\format{A data frame with 10 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nl100}}{Food poverty line}
\item{\code{nl150}}{National poverty line (100\%)}
\item{\code{nl200}}{National poverty line (150\%)}
\item{\code{half100}}{National poverty line (200\%)}
\item{\code{ppp125}}{Poorest half below 100\% national}
\item{\code{ppp200}}{Below $1.25 per day purchasing power parity (2005)}
\item{\code{ppp250}}{Below $2.00 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp844}}{Below $5.00 per day purchasing power parity (2005)}
}}
\source{
\url{www.povertyindex.org}
}
\usage{
ppiBOL2015
}
\description{
Poverty Probability Index (PPI) lookup table for Bolivia
}
\examples{
  # Access Bolivia PPI table
  ppiBOL2015

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiBOL2015[ppiBOL2015$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiBOL2015, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the food
  # poverty line definition
  ppiScore <- 50
  ppiBOL2015[ppiBOL2015$score == ppiScore, "nlFood"]

}
\keyword{datasets}
