% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ppc_members.R
\name{ppc_members}
\alias{ppc_members}
\title{Get Congress data from ProPublica's API}
\usage{
ppc_members(congress = "116", chamber = c("house", "senate"),
  api_key = NULL, raw = FALSE)
}
\arguments{
\item{congress}{The number of Congress of interest}

\item{chamber}{Specify the chamber of Congress typically "house" or "senate";
sometimes "both" or "joint"}

\item{api_key}{The actual API key string provided by ProPublica.}

\item{raw}{Logical indicating whether to return the raw response object. The
default (FALSE) parses the content and returns a tibble data frame.}
}
\value{
Depending on the raw parameter, this function returns a tibble data
frame with member information or the response object returned by curl

A data frame of congressional members information
}
\description{
Retrieves congress data from api.propublica.org
}
\details{
To apply for a ProPublica API use the following link:
\url{https://www.propublica.org/datastore/api/propublica-congress-api}.
Complete and submit the provided form to receive your API key.
}
\examples{
\dontrun{
## get data on house for 116th congress (requires API key)
h116 <- ppc_congress(congress = "116", chamber = "house")
}
}
\seealso{
\url{https://projects.propublica.org/api-docs/congress-api/}
}
