% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mlrF.partial.R
\name{mlrF.partial}
\alias{mlrF.partial}
\title{Power calculation for a multiple linear regression partial F test}
\usage{
mlrF.partial(
  N = NULL,
  p = NULL,
  q = NULL,
  pc = NULL,
  Rsq.red = NULL,
  Rsq.full = NULL,
  alpha = 0.05,
  power = NULL,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{p}{The number of control predictors.}

\item{q}{The number of test predictors.}

\item{pc}{The partial correlation coefficient. Either both Rsq terms OR pc must be specified.}

\item{Rsq.red}{The squared population multiple correlation coefficient for the reduced model. Either both Rsq terms OR pc must be specified.}

\item{Rsq.full}{The squared population multiple correlation coefficient for the full model. Either both Rsq terms OR pc must be specified.}

\item{alpha}{The significance level or type 1 error rate; defaults to 0.05.}

\item{power}{The specified level of power.}

\item{v}{Either TRUE for verbose output or FALSE to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Conducts power and sample size calculations for a partial F test
in a multiple linear regression model.
This is a test that one or more coefficients are equal to zero
after controlling for a set of control predictors.
Can solve for power, N or alpha.
}
\examples{
mlrF.partial(N = 80, p = 3, q = 2, Rsq.red = 0.25, Rsq.full = 0.35)
mlrF.partial(N = 150, p = 4, pc = 0.2)
}
