% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Method.R
\name{plot.Method}
\alias{plot.Method}
\title{Plot the results of a sample size analysis}
\usage{
\method{plot}{Method}(
  x,
  step = 3,
  last = TRUE,
  save = FALSE,
  path = NULL,
  width = 14,
  height = 10,
  ...
)
}
\arguments{
\item{x}{An object instance of class \code{Method}.}

\item{step}{A single positive integer representing the method step that
should be plotted. Possibles values are \code{1} for the first step, \code{2} for the
second step, and \code{3} for the third step of the method.}

\item{last}{A logical value indicating whether the last iteration of the
method should be plotted. The default is \code{TRUE}, indicating that the last
iteration should be plotted.}

\item{save}{A logical value indicating whether the plot should be saved to a
file on disk.}

\item{path}{A character string representing the path (i.e., including the
filename and extension) where the plot should be saved on disk. If \code{NULL},
the plot will be saved in the current working directory with a filename
generated based on the current system time and a \code{.pdf} extension. See
\code{\link[ggplot2:ggsave]{ggplot2::ggsave()}} for supported file types.}

\item{width}{A single numerical value representing the desired plot width.
The default unit is inches (i.e., set by \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}), unless
overridden by providing the \code{units} argument via \code{...}.}

\item{height}{A single numerical value representing the desired plot height.
The default unit is inches (i.e., set by \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}), unless
overridden by providing the \code{units} argument via \code{...}.}

\item{...}{Optional arguments to be passed to \code{\link[ggplot2:ggsave]{ggplot2::ggsave()}}.}
}
\value{
An \link[ggplot2:ggplot]{ggplot2::ggplot} object containing the plot for the requested step of the
method. The plot object returned can be further modified and also contains
the \link{patchwork} class applied.

\if{html}{
Example of a plot for each step of the method:

\out{<div style="text-align: center">}
\out{<p>}\strong{Step 1: Monte Carlo Replications}\out{</p>}
\figure{example-step-1.png}{options: style="width: 640px; max-width: 90\%;" alt="Example Step 1"}
\out{</div>}

\out{<div style="text-align: center">}
\out{<p>}\strong{Step 2: Curve Fitting}\out{</p>}
\figure{example-step-2.png}{options: style="width: 640px; max-width: 90\%;" alt="Example Step 2"}
\out{</div>}

\out{<div style="text-align: center">}
\out{<p>}\strong{Step 3: Bootstrapping}\out{</p>}
\figure{example-step-3.png}{options: style="width: 640px; max-width: 90\%;" alt="Example Step 3"}
\out{</div>}
}
}
\description{
This function plots the results for each step of the method.
}
\seealso{
\code{\link[=summary.Method]{summary.Method()}}, \code{\link[=powerly]{powerly()}}
}
