% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regroup.R
\name{regroup.powdRfps}
\alias{regroup.powdRfps}
\title{regroup}
\usage{
\method{regroup}{powdRfps}(x, y, ...)
}
\arguments{
\item{x}{A \code{powdRfps} object}

\item{y}{A data frame. First column contains the phase IDs covering all those present in
\code{x$phases$phase_id}. Second column contains the desired grouping of each phase.}

\item{...}{other arguments}
}
\value{
a \code{powdRfps} object with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the count intensities of fitted XRPD pattern}
\item{measured}{a vector of the count intensities of original XRPD measurement (aligned)}
\item{residuals}{a vector of the residuals (measured minus fitted)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern}
\item{phases_grouped}{the phases dataframe grouped and summed by phase_name}
\item{obj}{named vector of the objective parameters summarising the quality of the fit}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
\item{inputs}{a list of input arguments used in the function call}
}
\description{
\code{regroup.powdRfps} allows an alternative grouping structure to be applied to \code{powdRfps}
objects.
}
\details{
\code{powdRfps} objects contain a data frame called \code{phases_grouped}
that summarises phase concentrations based on defined mineral groups from the \code{powdRlib}
reference library. \code{regroup} allows you to change this grouping structure by supplying
new group identities.
}
\examples{
#Load the minerals library
data(minerals)

#Load the soils data
data(soils)

#Load the regrouping structure
data(minerals_regroup)

\dontrun{
fps_sandstone <- fps(lib = minerals,
                     smpl = soils$sandstone,
                     refs = minerals$phases$phase_id,
                     std = "QUA.1",
                     align = 0.2)

fps_sandstone_regrouped <- regroup(fps_sandstone,
                                   minerals_regroup)

fps_sandstone_regrouped$phases_grouped

}
}
