% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fps.R
\name{fps}
\alias{fps}
\title{Full pattern summation}
\usage{
fps(lib, ...)
}
\arguments{
\item{lib}{A \code{powdRlib} object representing the reference library. Created using the
\code{powdRlib} constructor function.}

\item{...}{Other parameters passed to methods e.g. \code{fps.powdRlib}}
}
\value{
a list with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned)}
\item{residuals}{a vector of the residuals (fitted vs measured)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern}
\item{phases_grouped}{the phases dataframe grouped by phase_name and summed}
\item{rwp}{the Rwp of the fitted vs measured pattern}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
\item{inputs}{a list of input arguments used in the function call}
}
\description{
\code{fps} returns estimates of phase concentrations using full pattern
summation of X-ray powder diffraction data. For more details see \code{?fps.powdRlib}.
}
\details{
Applies full pattern summation (Chipera & Bish, 2002, 2013; Eberl, 2003) to an XRPD
measurement to quantify phase concentrations. Requires a \code{powdRlib} library of
reference patterns with reference intensity ratios in order to derive
mineral concentrations.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

#Since the reference library is relatively small,
#the whole library can be used at once to get an
#estimate of the phases within each sample.
\dontrun{
fps_sand <-  fps(lib = minerals,
                 smpl = soils$sandstone,
                 refs = minerals$phases$phase_id,
                 std = "QUA.1",
                 align = 0.2)

fps_lime <- fps(lib = minerals,
                smpl = soils$limestone,
                refs = minerals$phases$phase_id,
                std = "QUA.1",
                align = 0.2)

fps_granite <- fps(lib = minerals,
                   smpl = soils$granite,
                   refs = minerals$phases$phase_id,
                   std = "QUA.1",
                   align = 0.2)

#Alternatively run all 3 at once using lapply

fps_soils <- lapply(soils, fps,
                    lib = minerals,
                    std = "QUA.2",
                    refs = minerals$phases$phase_id,
                    align = 0.2)

#Using the rockjock library:

data(rockjock)
data(rockjock_mixtures)

rockjock_1 <- fps(lib = rockjock,
                  smpl = rockjock_mixtures$Mix1,
                  refs = c("ORDERED_MICROCLINE",
                           "LABRADORITE",
                           "KAOLINITE_DRY_BRANCH",
                           "MONTMORILLONITE_WYO",
                           "ILLITE_1M_RM30",
                           "CORUNDUM"),
                  std = "CORUNDUM",
                  align = 0.3)

#Alternatively you can specify the internal standard
#concentration if known:
rockjock_1s <- fps(lib = rockjock,
                 smpl = rockjock_mixtures$Mix1,
                 refs = c("ORDERED_MICROCLINE",
                          "LABRADORITE",
                          "KAOLINITE_DRY_BRANCH",
                          "MONTMORILLONITE_WYO",
                          "ILLITE_1M_RM30",
                          "CORUNDUM"),
                 std = "CORUNDUM",
                 std_conc = 20,
                 align = 0.3)

}
}
\references{
Chipera, S.J., Bish, D.L., 2013. Fitting Full X-Ray Diffraction Patterns for Quantitative Analysis:
A Method for Readily Quantifying Crystalline and Disordered Phases. Adv. Mater. Phys. Chem. 03, 47-53.
doi:10.4236/ampc.2013.31A007

Chipera, S.J., Bish, D.L., 2002. FULLPAT: A full-pattern quantitative analysis program for X-ray powder
diffraction using measured and calculated patterns. J. Appl. Crystallogr. 35, 744-749.
doi:10.1107/S0021889802017405

Eberl, D.D., 2003. User's guide to RockJock - A program for determining quantitative mineralogy from
powder X-ray diffraction data. Boulder, CA.
}
