% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/afps.R
\name{afps}
\alias{afps}
\title{Automated full pattern summation}
\usage{
afps(lib, ...)
}
\arguments{
\item{lib}{A \code{powdRlib} object representing the reference library. Created using the
\code{powdRlib} constructor function.}

\item{...}{Other parameters passed to methods e.g. \code{afps.powdRlib}}
}
\value{
a list with components:
\item{tth}{a vector of the 2theta scale of the fitted data}
\item{fitted}{a vector of the fitted XRPD pattern}
\item{measured}{a vector of the original XRPD measurement (aligned)}
\item{background}{a vector of the fitted background used to estimate limits of detection}
\item{residuals}{a vector of the residuals (fitted vs measured)}
\item{phases}{a dataframe of the phases used to produce the fitted pattern}
\item{phases_summary}{the phases dataframe grouped by phase_name and summarised (sum)}
\item{rwp}{the Rwp of the fitted vs measured pattern}
\item{weighted_pure_patterns}{a dataframe of reference patterns used to produce the fitted pattern.
All patterns have been weighted according to the coefficients used in the fit}
\item{coefficients}{a named vector of coefficients used to produce the fitted pattern}
}
\description{
\code{afps} returns estimates of phase concentrations using automated full pattern
summation of X-ray powder diffraction data. It is designed for high-throughput cases
involving mineral quantification from large reference libraries. For more details
see \code{?afps.powdRlib}.
}
\details{
Applies automated full pattern summation to an XRPD
measurement to quantify phase concentrations. Requires a \code{powdRlib} library of
reference patterns with pre-measured reference intensity ratios in order to derive
mineral concentrations.
}
\examples{
#Load the minerals library
data(minerals)

# Load the soils data
data(soils)

#Since the reference library is relatively small,
#the whole library can be used at once to get an
#estimate of the phases within each sample.
\dontrun{
afps_sand <-  afps(lib = minerals,
                 smpl = soils$sandstone,
                 std = "QUA.1",
                 amorphous = "ORG",
                 align = 0.2)

afps_lime <- afps(lib = minerals,
                smpl = soils$limestone,
                std = "QUA.1",
                amorphous = "ORG",
                align = 0.2)

afps_granite <- afps(lib = minerals,
                   smpl = soils$granite,
                   std = "QUA.1",
                   amorphous = "ORG",
                   align = 0.2)
}
}
\references{
Chipera, S.J., Bish, D.L., 2013. Fitting Full X-Ray Diffraction Patterns for Quantitative Analysis:
A Method for Readily Quantifying Crystalline and Disordered Phases. Adv. Mater. Phys. Chem. 03, 47-53.
doi:10.4236/ampc.2013.31A007

Chipera, S.J., Bish, D.L., 2002. FULLPAT: A full-pattern quantitative analysis program for X-ray powder
diffraction using measured and calculated patterns. J. Appl. Crystallogr. 35, 744-749.
doi:10.1107/S0021889802017405

Eberl, D.D., 2003. User's guide to ROCKJOCK - A program for determining quantitative mineralogy from
powder X-ray diffraction data. Boulder, CA.
}
