% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepost_estimation_helpers.R
\name{ebp_reportdescriptives}
\alias{ebp_reportdescriptives}
\title{Create Descriptive Statistics for Small Area Estimation Report}
\usage{
ebp_reportdescriptives(
  model,
  direct,
  pop_data,
  pop_domains,
  smp_data,
  threshold = NULL,
  weights = NULL,
  pop_weights = NULL,
  CV_level,
  indicator = "Head_Count"
)
}
\arguments{
\item{model}{an object returned by the ebp function of type "emdi ebp",
representing point and MSE estimates}

\item{direct}{an object of type "direct","emdi", representing point
and MSE estimates.}

\item{pop_data}{the population/census/training data}

\item{pop_domains}{the target area variable within `pop_data`}

\item{smp_data}{sample data}

\item{threshold}{a number defining a threshold. The  argument defaults to
\code{NULL}. In this case, the threshold is set to 60\% of the median of the
variable that is selected as dependent variable similary to the
at-risk-of-poverty rate used in the EU (see also
\cite{Social Protection  Committee 2001}). However, any desired threshold can
be chosen.}

\item{weights}{a character string containing the name of a variable that
indicates weights in the sample data. If a character string is provided a
weighted version of the ebp will be used. The variable has to be numeric.
Defaults to NULL.}

\item{pop_weights}{a character string containing the name of a variable that
indicates population weights in the populatation data. If a character string
is provided weighted indicators are estimated using population weights.
The variable has to be numeric. Defaults to NULL.}

\item{CV_level}{the variable level at which Coefficient of Variation should
be computed}

\item{indicator}{a character string containing the name of the indicator to
compute the Coefficient of Variation for. Defaults to "Head_Count"}
}
\value{
an list containing three dataframes (first dataframe with direct an
ebp CV values, second dataframe with basic statistics and third dataframe
with national poverline and rate for census and survey
}
\description{
This function estimates the coefficient of variation at level specified,
basic statistics such number of units, regions and target areas as well as
the threshold on which SAE is applied and the outcome indicator of interest
(i.e. poverty line and poverty rate). These indicators are all expressed for
the census and survey
}
\examples{
\donttest{
data("eusilcA_pop")
data("eusilcA_smp")

# estimate a unit model
ebp_model <- ebp(fixed = eqIncome ~ gender + eqsize + cash +
                    self_empl + unempl_ben + age_ben + surv_ben + sick_ben +
                    dis_ben + rent + fam_allow + house_allow + cap_inv +
                    tax_adj,
                 pop_data = eusilcA_pop, pop_domains = "district",
                 smp_data = eusilcA_smp, smp_domains = "district",
                 na.rm = TRUE, weights = "weight",
                 pop_weights = "hhsize", MSE = TRUE, weights_type = "nlme",
                 B = 2, L = 2)

# estimate direct
direct_est <- direct(y = "eqIncome", smp_data = eusilcA_smp,
                     smp_domains = "district", weights = "weight",
                     var = TRUE, B = 2)

# descritives
ebp_reportdescriptives(model = ebp_model, direct = direct_est,
                       smp_data = eusilcA_smp, weights = "weight",
                       pop_weights = "hhsize", CV_level = "state",
                       pop_data = eusilcA_pop, pop_domains = "district")
}
}
