% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotsNtables.R
\name{backtestBoxPlot}
\alias{backtestBoxPlot}
\title{Create boxplot from backtest results}
\usage{
backtestBoxPlot(
  bt,
  measure = "Sharpe ratio",
  type = c("ggplot2", "simple"),
  ...
)
}
\arguments{
\item{bt}{Backtest results as produced by the function \code{\link{portfolioBacktest}}.}

\item{measure}{String to select a performane measure from
\code{"Sharpe ratio"}, \code{"max drawdown"}, \code{"annual return"}, \code{"annual volatility"}, 
\code{"Sterling ratio"}, \code{"Omega ratio"}, and \code{"ROT bps"}.
 Default is \code{"Sharpe ratio"}.}

\item{type}{Type of plot. Valid options: \code{"ggplot2", "simple"}. Default is 
\code{"ggplot2"}.}

\item{...}{Additional parameters. For example: 
\code{mar} for margins as in \code{par()} (for the case of plot \code{type = "simple"}); and
\code{alpha} for the alpha of each backtest dot (for the case of plot \code{type = "ggplot2"}), 
             set to \code{0} to remove the dots.}
}
\description{
Create boxplot from a portfolio backtest obtained with the function 
\code{\link{portfolioBacktest}}. By default the boxplot is based on the 
package \code{ggplot2} (also plots a dot for each single backtest), but the user can also 
specify a simple base plot.
}
\examples{
\donttest{
library(portfolioBacktest)
data(dataset10)  # load dataset

# define your own portfolio function
quintile_portfolio <- function(data, ...) {
  X <- diff(log(data$adjusted))[-1]  
  N <- ncol(X)
  ranking <- sort(colMeans(X), decreasing = TRUE, index.return = TRUE)$ix
  w <- rep(0, N)
  w[ranking[1:round(N/5)]] <- 1/round(N/5)
  return(w)
}

# do backtest
bt <- portfolioBacktest(list("Quintile" = quintile_portfolio), dataset10,
                        benchmark = c("uniform", "index"))

# now we can plot
backtestBoxPlot(bt, "Sharpe ratio")
backtestBoxPlot(bt, "Sharpe ratio", type = "simple")
}

}
\seealso{
\code{\link{summaryBarPlot}}, \code{\link{backtestChartCumReturn}}, 
         \code{\link{backtestChartDrawdown}}, \code{\link{backtestChartStackedBar}}
}
\author{
Daniel P. Palomar and Rui Zhou
}
