% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualizations.r
\name{poppr.msn}
\alias{msn.poppr}
\alias{poppr.msn}
\title{Create a minimum spanning network of selected populations using a distance 
matrix.}
\usage{
poppr.msn(gid, distmat, palette = topo.colors, mlg.compute = "original",
  sublist = "All", blacklist = NULL, vertex.label = "MLG",
  gscale = TRUE, glim = c(0, 0.8), gadj = 3, gweight = 1,
  wscale = TRUE, showplot = TRUE, include.ties = FALSE, threshold = 0,
  clustering.algorithm = "farthest_neighbor", ...)
}
\arguments{
\item{gid}{a \code{\link{genind}}, \code{\link{genclone}},
\code{\link{genlight}}, or \code{\link{snpclone}} object}

\item{distmat}{a distance matrix that has been derived from your data set.}

\item{palette}{a \code{vector} or \code{function} defining the color palette 
to be used to color the populations on the graph. It defaults to 
\code{\link{topo.colors}}. See examples for details.}

\item{mlg.compute}{if the multilocus genotypes are set to "custom" (see 
\code{\link{mll.custom}} for details) in your genclone object, this will 
specify which mlg level to calculate the nodes from. See details.}

\item{sublist}{a \code{vector} of population names or indexes that the user 
wishes to keep. Default to "ALL".}

\item{blacklist}{a \code{vector} of population names or indexes that the user
wishes to discard. Default to \code{NULL}}

\item{vertex.label}{a \code{vector} of characters to label each vertex. There
are two defaults: \code{"MLG"} will label the nodes with the multilocus 
genotype from the original data set and \code{"inds"} will label the nodes 
with the representative individual names.}

\item{gscale}{"grey scale". If this is \code{TRUE}, this will scale the color
of the edges proportional to the observed distance, with the lines becoming
darker for more related nodes. See \code{\link{greycurve}} for details.}

\item{glim}{"grey limit". Two numbers between zero and one. They determine 
the upper and lower limits for the \code{\link{gray}} function. Default is 
0 (black) and 0.8 (20\% black). See \code{\link{greycurve}} for details.}

\item{gadj}{"grey adjust". a positive \code{integer} greater than zero that 
will serve as the exponent to the edge weight to scale the grey value to 
represent that weight. See \code{\link{greycurve}} for details.}

\item{gweight}{"grey weight". an \code{integer}. If it's 1, the grey scale 
will be weighted to emphasize the differences between closely related 
nodes. If it is 2, the grey scale will be weighted to emphasize the 
differences between more distantly related nodes. See 
\code{\link{greycurve}} for details.}

\item{wscale}{"width scale". If this is \code{TRUE}, the edge widths will be 
scaled proportional to the inverse of the observed distance , with the 
lines becoming thicker for more related nodes.}

\item{showplot}{logical. If \code{TRUE}, the graph will be plotted. If 
\code{FALSE}, it will simply be returned.}

\item{include.ties}{logical. If \code{TRUE}, the graph will include all edges
that were arbitrarily passed over in favor of another edge of equal weight.
If \code{FALSE}, which is the default, one edge will be arbitrarily 
selected when two or more edges are tied, resulting in a pure minimum
spanning network.}

\item{threshold}{numeric. If greater than the default value of 0.0, this will
be passed to \code{\link{mlg.filter}} prior to creating the msn.}

\item{clustering.algorithm}{string. If \code{threshold} is greater than 0,
this this will also be passed to \code{\link{mlg.filter}} prior to creating
the msn. For both of these arguments, see \code{\link{mlg.filter}} for more
details.}

\item{...}{any other arguments that could go into plot.igraph}
}
\value{
\item{graph}{a minimum spanning network with nodes corresponding to 
  MLGs within the data set. Colors of the nodes represent population 
  membership. Width and color of the edges represent distance.} 
  \item{populations}{a vector of the population names corresponding to the 
  vertex colors} \item{colors}{a vector of the hexadecimal representations of
  the colors used in the vertex colors}
}
\description{
Create a minimum spanning network of selected populations using a distance 
matrix.
}
\details{
Each node on the graph represents a different multilocus genotype. 
  The edges on the graph represent genetic distances that connect the
  multilocus genotypes. In genclone objects, it is possible to set the
  multilocus genotypes to a custom definition. This creates a problem for
  clone correction, however, as it is very possible to define custom lineages
  that are not monophyletic. When clone correction is performed on these
  definitions, information is lost from the graph. To circumvent this, The
  clone correction will be done via the computed multilocus genotypes, either
  "original" or "contracted". This is specified in the \code{mlg.compute}
  argument, above.
}
\note{
The edges of these graphs may cross each other if the graph becomes too
  large.
}
\examples{

# Load the data set and calculate the distance matrix for all individuals.
data(Aeut)
A.dist <- diss.dist(Aeut)

# Graph it.
A.msn <- poppr.msn(Aeut, A.dist, gadj=15, vertex.label=NA)

\dontrun{
# Set subpopulation structure.
Aeut.sub <- as.genclone(Aeut)
setPop(Aeut.sub) <- ~Pop/Subpop

# Plot respective to the subpopulation structure
As.msn <- poppr.msn(Aeut.sub, A.dist, gadj=15, vertex.label=NA)

# Show only the structure of the Athena population.
As.msn <- poppr.msn(Aeut.sub, A.dist, gadj=15, vertex.label=NA, sublist=1:10)

# Let's look at the structure of the microbov data set

library("igraph")
data(microbov)
micro.dist <- diss.dist(microbov, percent = TRUE)
micro.msn <- poppr.msn(microbov, micro.dist, vertex.label=NA)

# Let's plot it and show where individuals have < 15\% of their genotypes 
# different.

edge_weight <- E(micro.msn$graph)$weight
edge_labels <- ifelse(edge_weight < 0.15, round(edge_weight, 3), NA)
plot.igraph(micro.msn$graph, edge.label = edge_labels, vertex.size = 2, 
edge.label.color = "red")

}

}
\author{
Javier F. Tabima, Zhian N. Kamvar, Jonah C. Brooks
}
\seealso{
\code{\link{plot_poppr_msn}} \code{\link{nancycats}},
  \code{\link{upgma}}, \code{\link{nj}}, \code{\link{nodelabels}},
  \code{\link{tab}}, \code{\link{missingno}}, \code{\link{bruvo.msn}},
  \code{\link{greycurve}}
}

