\name{monkeyflower}
\alias{monkeyflower}
\docType{data}
\title{Projection matrices for monkeyflower}
\description{
  Pooled and annual projection matrices of central and marginal
  populations of monkeyflowers (\emph{Mimulus cardinalis} and
  \emph{M. lewisii})
}

\usage{data(monkeyflower)}
\format{
  A data frame with 32 projection matrices, arranged with one matrix per row
   \describe{
    \item{\code{species}}{M. cardinalis or M. lewisii}
    \item{\code{site}}{Study site}
    \item{\code{year}}{Start year of projection interval or pooled for all three years}
    \item{\code{a11}}{matrix element a11;  seed to seed transition or seed bank survival}
    \item{\code{a12}}{matrix element a12;  small nr to seed - fertility}
    \item{\code{a13}}{matrix element a13;  large nr to seed - fertility}
    \item{\code{a14}}{matrix element a14;  reprod to seed - fertility}
    \item{\code{a21}}{matrix element a21;  seed to small nr - growth}
    \item{\code{a22}}{matrix element a22;  small nr to small nr -stasis}
    \item{\code{a23}}{matrix element a23;  large nr to small nr - regress}
    \item{\code{a24}}{matrix element a24;  reprod to small nr - regress}
    \item{\code{a31}}{matrix element a31;  seed to large nr - growth  }
    \item{\code{a32}}{matrix element a32;  small nr to large nr - growth  }
    \item{\code{a33}}{matrix element a33;  large nr to large nr - stasis  }
    \item{\code{a34}}{matrix element a34;  reprod to large nr - regress  }
    \item{\code{a41}}{matrix element a41;  seed to reprod - growth  }
    \item{\code{a42}}{matrix element a42;  small nr to reprod - growth  }
    \item{\code{a43}}{matrix element a43;  large nr to reprod - growth  }
    \item{\code{a44}}{matrix element a44;  reprod to reprod - stasis  }
  }
}
\details{
 Matrix constructed using a post-breeding census with four stage
 classes: Seeds, small non-reproductive, large non-reproductive, and
 reproductive.

}
\source{
  \url{http://www.esapubs.org/archive/ecol/E087/126/appendix-E.htm}
}
\references{
   Amy Lauren Angert. 2006. Demography of central and marginal
   populations of monkeyflowers (\emph{Mimulus cardinalis} and
   \emph{M. lewisii}). Ecology 87:2014-2025.
}
\examples{
data(monkeyflower)
## convert M. cardinalis rows to list of 16 matrices
A <- subset(monkeyflower, species=="cardinalis")
# use as.matrix to convert data.frame to numeric matrix
A<-split( as.matrix(A[, 4:19]),  paste(A$site, A$year))
stages<-c("seed", "sm.nr", "lg.nr", "repro")
## convert to list of 16 matrices
A<-lapply(A, matrix, nrow=4, byrow=TRUE, dimnames=list(stages,stages))
A[8]
image2(A[[8]], round=8, mar=c(1,3,4.5,1))
title( paste("M. cardinalis - ", names(A[8])), line=2.5)


## plot like figure 1A
x<- matrix(sapply(A, lambda), ncol=4)
colnames(x)<-c("BU",  "CA", "RP", "WA")
rownames(x)<-c(2000:2002, "pooled")
x<-x[,c(1,3,4,2)]
colrs<-gray(0:3 / 3)[c(1,3,2,4)]
barplot(x, beside=TRUE, las=1, col=colrs, ylim=c(0,2),
ylab="Population growth rate", main="Mimulus cardinalis")
box()
abline(h=1, lwd=.5)
legend(1,1.95, rownames(x), fill=colrs, bty='n')

}
\keyword{datasets}
