% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.params2qpGraphFiles.R
\name{graph.params2qpGraphFiles}
\alias{graph.params2qpGraphFiles}
\title{Generate files for the qpGraph software from a graph.params object}
\usage{
graph.params2qpGraphFiles(
  graph.params,
  outfileprefix = "out",
  n.printed.dec = 4,
  verbose = TRUE
)
}
\arguments{
\item{graph.params}{An object of class graph.params containing graph information with Fstats information (see the function generate.graph.params)}

\item{outfileprefix}{The prefix of the qpGraph files}

\item{n.printed.dec}{Number of decimal to be printed (if not enough may lead to fatalx error in qpGraph)}

\item{verbose}{If TRUE extra information is printed on the terminal}
}
\value{
The three files described in the details section
}
\description{
Generate files for the qpGraph software from a graph.params object
}
\details{
This function generates the three files required by qpGraph: i) a file named {outfileprefix}.graph containing the graph in appropriate format; ii) a file named {outfileprefix}.fstats file containing the fstats estimates of fstats (and their covariance); iii) a file named {outfileprefix}.parqpGraph containing essential parameter information to run qpGraph (this may be edited by hand if other options are needed). The qpGraph software may then be run using the following options -p {outfileprefix}.parqpGraph -g {outfileprefix}.graph -o out.ggg -d out.dot.
}
\seealso{
To generate graph.params object, see \code{\link{generate.graph.params}}
}
