% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{compute_F4fromF2samples}
\alias{compute_F4fromF2samples}
\alias{.compute_F4fromF2samples}
\title{compute_F4fromF2samples}
\usage{
.compute_F4fromF2samples(blockF2, npops, verbose)
}
\arguments{
\item{blockF2}{Numeric Matrix with nF2=(npop*(npop-1))/2 rows and nblocks columns matrix containing pairwise-pop F2 estimates for each block-jackknife sample (l.o.o.)}

\item{npops}{Integer giving the number of populations}

\item{verbose}{Logical (if TRUE progression bar is printed on the terminal)}
}
\value{
Return a matrix with nF4=(npops*(npops-1)/2) * ((npops-2)*(npops-3)/2) / 2 rows and two columns corresponding to the mean and the s.e. of F4 estimates for all possible configurations
}
\description{
Compute all F4 from F2 values obtained from each block-jackknife bloc
}
\details{
Compute F4 estimates and their s.e. based on block-jackknife estimates of all F2 (and heterozygosities)
}
\examples{
#
}
