% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workhorses.R
\docType{methods}
\name{rprocess}
\alias{rprocess}
\alias{rprocess,ANY-method}
\alias{rprocess,missing-method}
\alias{rprocess,pomp-method}
\title{rprocess}
\usage{
\S4method{rprocess}{pomp}(
  object,
  x0 = rinit(object),
  t0 = timezero(object),
  times = time(object),
  params = coef(object),
  ...
)
}
\arguments{
\item{object}{an object of class \sQuote{pomp}, or of a class that extends \sQuote{pomp}.
This will typically be the output of \code{pomp}, \code{simulate}, or one of the \pkg{pomp} inference algorithms.}

\item{x0}{an \code{nvar} x \code{nrep} matrix containing the starting state of the system.
Columns of \code{x0} correspond to states;
rows to components of the state vector.
One independent simulation will be performed for each column.
Note that in this case, \code{params} must also have \code{nrep} columns.}

\item{t0}{the initial time, i.e., the time corresponding to the state in \code{x0}.}

\item{times}{a numeric vector (length \code{ntimes}) containing times.
These must be in non-decreasing order.}

\item{params}{a \code{npar} x \code{nrep} matrix of parameters.
Each column is treated as an independent parameter set, in correspondence with the corresponding column of \code{x0}.}

\item{...}{additional arguments are ignored.}
}
\value{
\code{rprocess} returns a rank-3 array with rownames.
Suppose \code{x} is the array returned.
Then \preformatted{dim(x)=c(nvars,nrep,ntimes),}
where \code{nvars} is the number of state variables (=\code{nrow(x0)}),
\code{nrep} is the number of independent realizations simulated (=\code{ncol(x0)}), and
\code{ntimes} is the length of the vector \code{times}.
\code{x[,j,k]} is the value of the state process in the \code{j}-th realization at time \code{times[k]}.
The rownames of \code{x} will correspond to those of \code{x0}.
}
\description{
\code{rprocess} simulates the process-model portion of partially-observed Markov process.
}
\details{
When \code{rprocess} is called, \code{t0} is taken to be the initial time (i.e., that corresponding to \code{x0}).
The values in \code{times} are the times at which the state of the simulated processes are required.
}
\seealso{
Specification of the process-model simulator: \link{rprocess specification}

More on \pkg{pomp} workhorse functions: 
\code{\link{dmeasure}()},
\code{\link{dprior}()},
\code{\link{dprocess}()},
\code{\link{emeasure}()},
\code{\link{flow}()},
\code{\link{partrans}()},
\code{\link{pomp-package}},
\code{\link{rinit}()},
\code{\link{rmeasure}()},
\code{\link{rprior}()},
\code{\link{skeleton}()},
\code{\link{vmeasure}()},
\code{\link{workhorses}}
}
\concept{extending the pomp package}
\concept{low-level interface}
\concept{pomp workhorses}
