% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design.R, R/profile_design.R, R/runif_design.R,
%   R/slice_design.R, R/sobol.R
\name{design}
\alias{design}
\alias{profileDesign}
\alias{runifDesign}
\alias{sliceDesign}
\alias{sobolDesign}
\title{Design matrices for pomp calculations}
\usage{
profileDesign(
  ...,
  lower,
  upper,
  nprof,
  type = c("sobol", "runif"),
  stringsAsFactors = getOption("stringsAsFactors", FALSE)
)

runifDesign(lower = numeric(0), upper = numeric(0), nseq)

sliceDesign(center, ...)

sobolDesign(lower = numeric(0), upper = numeric(0), nseq)
}
\arguments{
\item{...}{In \code{profileDesign}, additional arguments specify the parameters over which to profile and the values of these parameters.
In \code{sliceDesign}, additional numeric vector arguments specify the locations of points along the slices.}

\item{lower, upper}{named numeric vectors giving the lower and upper bounds
of the ranges, respectively.}

\item{nprof}{The number of points per profile point.}

\item{type}{the type of design to use.
\code{type="sobol"} uses \code{\link{sobolDesign}};
\code{type="runif"} uses \code{\link{runifDesign}}.}

\item{stringsAsFactors}{should character vectors be converted to factors?}

\item{nseq}{Total number of points requested.}

\item{center}{\code{center} is a named numeric vector specifying the point
through which the slice(s) is (are) to be taken.}
}
\value{
\code{profileDesign} returns a data frame with \code{nprof} points per profile point.

\code{runifDesign} returns a data frame with \code{nseq} rows and one column for each variable named in \code{lower} and \code{upper}.

\code{sliceDesign} returns a data frame with one row per point.
The \sQuote{slice} variable indicates which slice the point belongs to.

\code{sobolDesign} returns a data frame with \code{nseq} rows and one column for each variable named in \code{lower} and \code{upper}.
}
\description{
These functions are useful for generating designs for the exploration of parameter space.

\code{profileDesign} generates a data-frame where each row can be used as the starting point for a profile likelihood calculation.

\code{runifDesign} generates a design based on random samples from a multivariate uniform distribution.

\code{sliceDesign} generates points along slices through a specified point.

\code{sobolDesign} generates a Latin hypercube design based on the Sobol' low-discrepancy sequence.
}
\details{
The Sobol' sequence generation is performed using codes from the
\href{http://ab-initio.mit.edu/nlopt/}{\pkg{NLopt} library} by S. Johnson.
}
\examples{
## Sobol' low-discrepancy design
plot(sobolDesign(lower=c(a=0,b=100),upper=c(b=200,a=1),nseq=100))

## Uniform random design
plot(runifDesign(lower=c(a=0,b=100),upper=c(b=200,a=1),100))

## A one-parameter profile design:
x <- profileDesign(p=1:10,lower=c(a=0,b=0),upper=c(a=1,b=5),nprof=20)
dim(x)
plot(x)

## A two-parameter profile design:
x <- profileDesign(p=1:10,q=3:5,lower=c(a=0,b=0),upper=c(b=5,a=1),nprof=200)
dim(x)
plot(x)

## A two-parameter profile design with random points:
x <- profileDesign(p=1:10,q=3:5,lower=c(a=0,b=0),upper=c(b=5,a=1),nprof=200,type="runif")
dim(x)
plot(x)

## A single 11-point slice through the point c(A=3,B=8,C=0) along the B direction.
x <- sliceDesign(center=c(A=3,B=8,C=0),B=seq(0,10,by=1))
dim(x)
plot(x)

## Two slices through the same point along the A and C directions.
x <- sliceDesign(c(A=3,B=8,C=0),A=seq(0,5,by=1),C=seq(0,5,length=11))
dim(x)
plot(x)

}
\references{
\Bratley1988

\Joe2003

\NLopt
}
\author{
Aaron A. King
}
\keyword{design}
