% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmcmc.R
\docType{methods}
\name{pmcmc}
\alias{pmcmc}
\alias{pmcmc,ANY-method}
\alias{pmcmc,missing-method}
\alias{pmcmc-data.frame}
\alias{pmcmc,data.frame-method}
\alias{pmcmc-pomp}
\alias{pmcmc,pomp-method}
\alias{pmcmc-pfilterd_pomp}
\alias{pmcmc,pfilterd_pomp-method}
\alias{pmcmc-pmcmcd_pomp}
\alias{pmcmc,pmcmcd_pomp-method}
\title{The particle Markov chain Metropolis-Hastings algorithm}
\usage{
\S4method{pmcmc}{data.frame}(data, Nmcmc = 1, proposal, Np,
  tol = 1e-17, max.fail = Inf, params, rinit, rprocess, dmeasure,
  dprior, ..., verbose = getOption("verbose", FALSE))

\S4method{pmcmc}{pomp}(data, Nmcmc = 1, proposal, Np, tol = 1e-17,
  max.fail = Inf, ..., verbose = getOption("verbose", FALSE))

\S4method{pmcmc}{pfilterd_pomp}(data, Nmcmc = 1, proposal, Np, tol,
  max.fail = Inf, ..., verbose = getOption("verbose", FALSE))

\S4method{pmcmc}{pmcmcd_pomp}(data, Nmcmc, proposal, ...,
  verbose = getOption("verbose", FALSE))
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.}

\item{Nmcmc}{The number of PMCMC iterations to perform.}

\item{proposal}{optional function that draws from the proposal
distribution.  Currently, the proposal distribution must be symmetric for
proper inference: it is the user's responsibility to ensure that it is.
Several functions that construct appropriate proposal function are
provided: see \link[=proposals]{MCMC proposals} for more information.}

\item{Np}{the number of particles to use.
This may be specified as a single positive integer, in which case the same number of particles will be used at each timestep.
Alternatively, if one wishes the number of particles to vary across timesteps, one may specify \code{Np} either as a vector of positive integers of length \preformatted{length(time(object,t0=TRUE))} or as a function taking a positive integer argument.
In the latter case, \code{Np(k)} must be a single positive integer, representing the number of particles to be used at the \code{k}-th timestep:
\code{Np(0)} is the number of particles to use going from \code{timezero(object)} to \code{time(object)[1]},
\code{Np(1)}, from \code{timezero(object)} to \code{time(object)[1]},
and so on,
while when \code{T=length(time(object,t0=TRUE))}, \code{Np(T)} is the number of particles to sample at the end of the time-series.}

\item{tol}{positive numeric scalar;
particles with likelihood less than \code{tol} are considered to be incompatible with the data.
See the section on \emph{Filtering Failures} for more information.}

\item{max.fail}{integer; the maximum number of filtering failures allowed (see below).
If the number of filtering failures exceeds this number, execution will terminate with an error.
By default, \code{max.fail} is set to infinity, so no error can be triggered.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{?rinit_spec}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, \link[=rprocess_spec]{see ?rprocess_spec for the documentation on these plugins}.}

\item{dmeasure}{evaluator of the measurement model density, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{dmeasure=NULL} removes the measurement density evaluator.
For more information, see \link[=dmeasure_spec]{?dmeasure_spec}.}

\item{dprior}{optional; prior distribution density evaluator, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
For more information, see \link[=prior_spec]{?prior_spec}.
Setting \code{dprior=NULL} resets the prior distribution to its default, which is a flat improper prior.}

\item{...}{additional arguments supply new or modify existing model characteristics or components.
See \code{\link{pomp}} for a full list of recognized arguments.

When named arguments not recognized by \code{\link{pomp}} are provided, these are made available to all basic components via the so-called \dfn{userdata} facility.
This allows the user to pass information to the basic components outside of the usual routes of covariates (\code{covar}) and model parameters (\code{params}).
See \link[=userdata]{?userdata} for information on how to use this facility.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
An object of class \sQuote{pmcmcd_pomp}.
}
\description{
The Particle MCMC algorithm for estimating the parameters of a
partially-observed Markov process.  Running \code{pmcmc} causes a particle
random-walk Metropolis-Hastings Markov chain algorithm to run for the
specified number of proposals.
}
\section{Re-running PMCMC Iterations}{

To re-run a sequence of PMCMC
iterations, one can use the \code{pmcmc} method on a \sQuote{pmcmc} object.
By default, the same parameters used for the original PMCMC run are re-used
(except for \code{tol}, \code{max.fail}, and \code{verbose}, the defaults
of which are shown above).  If one does specify additional arguments, these
will override the defaults.
}

\section{Filtering failures}{

If the degree of disagreement between model and data becomes sufficiently large, a \dQuote{filtering failure} results.
A filtering failure occurs when, at some time point, none of the \code{Np} particles is compatible with the data.
In particular, if the conditional likelihood of a particle at any time is below the tolerance value \code{tol}, then that particle is considered to be uninformative and its likelihood is taken to be zero.
A filtering failure occurs when this is the case for all particles.
A warning is generated when this occurs unless the cumulative number of failures exceeds \code{max.fail}, in which case an error is generated.
}

\references{
C. Andrieu, A. Doucet, and R. Holenstein (2010)
Particle Markov chain Monte Carlo methods.
Journal of the Royal Statistical Society, Series B, 72: 269–342.

C. Andrieu and G.O. Roberts (2009)
The pseudo-marginal approach for computation
Annals of Statistics, 37:697-725.
}
\seealso{
\link[=proposals]{MCMC proposals}

Other particle filter methods: \code{\link{bsmc2}},
  \code{\link{cond.logLik}}, \code{\link{eff.sample.size}},
  \code{\link{filter.mean}}, \code{\link{filter.traj}},
  \code{\link{mif2}}, \code{\link{pfilter}},
  \code{\link{pred.mean}}, \code{\link{pred.var}}

Other pomp parameter estimation methods: \code{\link{abc}},
  \code{\link{bsmc2}}, \code{\link{kalman}},
  \code{\link{mif2}}, \code{\link{nlf}},
  \code{\link{pomp-package}}, \code{\link{probe.match}},
  \code{\link{spect.match}}
}
\author{
Edward L. Ionides, Aaron A. King, Sebastian Funk
}
\concept{particle filter methods}
\concept{pomp parameter estimation methods}
