% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_belief.R
\name{update_belief}
\alias{update_belief}
\title{Belief Update}
\usage{
update_belief(
  model,
  belief = NULL,
  action = NULL,
  observation = NULL,
  episode = 1,
  digits = 7,
  drop = TRUE
)
}
\arguments{
\item{model}{a POMDP model. Defaults to the start belief state specified in
the model or "uniform".}

\item{belief}{the current belief state.}

\item{action}{the taken action.}

\item{observation}{the received observation.}

\item{episode}{Use transition and observation matrices for the given episode
for time-dependent POMDPs (see \code{\link{POMDP}}).}

\item{digits}{round decimals.}

\item{drop}{logical; drop the result to a vector if only a single belief
state is returned.}
}
\description{
Update the belief given a taken action and observation.
}
\examples{

data(Tiger)

update_belief(c(.5,.5), model = Tiger)
update_belief(c(.5,.5), action = "listen", observation = "tiger-left", model = Tiger)
update_belief(c(.15,.85), action = "listen", observation = "tiger-right", model = Tiger)

}
\seealso{
\code{\link{POMDP}}
}
\author{
Michael Hahsler
}
