% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyqtlR_functions.R
\name{convert_mappoly_to_phased.maplist}
\alias{convert_mappoly_to_phased.maplist}
\title{Function to extract the phased map from a mappoly.map object}
\usage{
convert_mappoly_to_phased.maplist(mappoly_object)
}
\arguments{
\item{mappoly_object}{An object of class 'mappoly.map', for example output of the function \code{mappoly::est_rf_hmm_sequential}}
}
\value{
A phased.maplist, with linkage group names LG1 etc. Each list item is a data.frame with columns marker, position followed
by the phased map, coded in 1 and 0 for presence/absence of SNP (alternative) allele on parental homologues (h) numbered 1:ploidy for parent 1
and ploidy + 1 : 2*ploidy for parent 2.
}
\description{
Convert MAPpoly.map object into a phased maplist, needed for IBD estimation
}
\examples{
library("mappoly")
phased.maplist <- convert_mappoly_to_phased.maplist(maps.hexafake)
}
