% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{marker_data_summary}
\alias{marker_data_summary}
\title{Summarize marker data}
\usage{
marker_data_summary(dosage_matrix, ploidy, pairing = c("random",
  "preferential"), parent1 = "P1", parent2 = "P2",
  progeny_incompat_cutoff = 0.1, verbose = TRUE, log = NULL)
}
\arguments{
\item{dosage_matrix}{An integer matrix with markers in rows and individuals in columns.}

\item{ploidy}{Integer. Ploidy of plant species.}

\item{pairing}{Type of pairing. "random" or "preferential".}

\item{parent1}{Name of first parent. Usually maternal parent.}

\item{parent2}{Name of second parent. Usually paternal parent.}

\item{progeny_incompat_cutoff}{The relative number of incompatible dosages per genotype that results in reporting
this genotype as incompatible. Incompatible dosages are greater than maximum number of alleles than can be inherited or
smaller than the minimum number of alleles that can be inherited.}

\item{verbose}{Logical, by default \code{TRUE} - should intermediate messages be written to stout?}

\item{log}{Character string specifying the log filename to which standard output should be written. If \code{NULL} log is send to stdout.}
}
\value{
Returns a list containing the following components:
\item{parental_info}{
  frequency table of different markertypes. Names start with parentnames, and behind that the dosage score.
}
\item{offspring_incompatible}{
  Rate of incompatible ("impossible") marker scores (given as percentages of the total number of observed marker scores per marker class)
}
\item{progeny_incompatible}{
  progeny names having incompatible dosage scores higher than threshold at progeny_incompat_cutoff.
}
}
\description{
Gives a frequency table of different markertypes, relative frequency per markertype of incompatible offspring and the names of incompatible progeny.
}
\examples{
data("ALL_dosages")
summary_list<-marker_data_summary(dosage_matrix = ALL_dosages, ploidy = 4)
}
