% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exported_functions.R
\name{plot_phased_maplist}
\alias{plot_phased_maplist}
\title{Visualise the phased homologue maplist}
\usage{
plot_phased_maplist(phased.maplist, ploidy = 4, ploidy2 = NULL,
  cols = c("black", "darkred", "navyblue"), width = 0.2,
  mapTitles = NULL)
}
\arguments{
\item{phased.maplist}{A list of phased linkage maps, the output of \code{\link{create_phased_maplist}}}

\item{ploidy}{Integer. Ploidy of the organism.}

\item{ploidy2}{Optional integer, by default \code{NULL}. Ploidy of parent 2, if different from parent 1.}

\item{cols}{Vector of colours for the integrated, parent1 and parent2 maps, respectively.}

\item{width}{Width of the linkage maps, by default 0.2}

\item{mapTitles}{Optional vector of titles for maps, by default names of maplist, or titles LG1, LG2 etc. are used.}
}
\description{
\code{plot_phased_maplist} is a function for visualising a phased maplist, the output of
\code{\link{create_phased_maplist}}
}
\examples{
data("phased.maplist")
plot_phased_maplist(phased.maplist)
}
