% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bwd.R
\name{bw_lcv_min_epa}
\alias{bw_lcv_min_epa}
\title{Minimum bandwidth allowed in likelihood cross-validation for
Epanechnikov kernels}
\usage{
bw_lcv_min_epa(X, d, kernel_type = c("prod", "sph")[1])
}
\arguments{
\item{X}{a matrix of size \code{c(n, sum(d) + r)} with the sample.}

\item{d}{vector of size \code{r} with dimensions.}

\item{kernel_type}{type of kernel employed: \code{1} for product kernel
(default); \code{2} for spherically symmetric kernel.}
}
\value{
The minimum bandwidth allowed.
}
\description{
This function computes the minimum bandwidth allowed in
likelihood cross-validation with Epanechnikov kernels, for a given dataset
and dimension.
}
\examples{
n <- 5
d <- 1:3
X <- r_unif_polysph(n = n, d = d)
h_min <- rep(bw_lcv_min_epa(X = X, d = d), length(d))
log_cv_kde_polysph(X = X, d = d, h = h_min - 1e-4, kernel = 2) # Problem
log_cv_kde_polysph(X = X, d = d, h = h_min + 1e-4, kernel = 2) # OK
}
