% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decode_method.R
\docType{methods}
\name{decode}
\alias{decode}
\alias{decode,character-method}
\title{Decode corpus or s-attribute.}
\usage{
decode(.Object, ...)

\S4method{decode}{character}(.Object, sAttribute = NULL, verbose = TRUE)
}
\arguments{
\item{.Object}{the corpus to decode (character vector)}

\item{...}{further parameters}

\item{sAttribute}{the s-attribute to decode}

\item{verbose}{logical}
}
\value{
a \code{data.table}
}
\description{
Decode either a corpus, or a s-attribute.
}
\examples{
\dontrun{
use("polmineR.sampleCorpus")

# Scenario 1: Decode one s-attribute
dt <- decode("PLPRBTTXT", sAttribute = "text_date")

# Scenario 2: Decode corpus entirely
dt <- decode("PLPRBTTXT")

}
}
\seealso{
\code{\link{encode}}
}
