% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lengthwidthsize.R
\name{lengthwidthsize}
\alias{lengthwidthsize}
\title{Converts pollinator body length*body width to body size (dry weight (mg)).}
\usage{
lengthwidthsize(BLW, Eq = "DIP")
}
\arguments{
\item{BLW}{A vector of fly body length*body width measurments (mm).}

\item{Eq}{a vector of a predictive allometry for Diptera, Hymenoptera or Lepidoptera. Options implemented are:}
}
\value{
A dataframe with body size, as dry weight (mg) is returned for each specimen from selected equation.
}
\description{
Calculates body size as dry weight (mg) from the equations described by Sample (1993) and others using body length*body width values (mm).
}
\examples{
lengthwidthsize(BLW=c(3,5,2), Eq = c("Brachycera"))
}
\references{
Kendall et al. (2018) Pollinator size and its consequences: Predictive allometry for pollinating insects. <doi:10.1101/397604>

Sample et al. (1993) Estimation of insect biomass by length and width. American Midland Naturalist, 234-240.
}
