% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/secure_rmd.R
\name{secure_rmd}
\alias{secure_rmd}
\title{Render and secure R Markdown document}
\usage{
secure_rmd(
  rmd_file_path,
  polished_config_args = list(),
  sign_in_page_args = list(),
  sign_out_button = NULL
)
}
\arguments{
\item{rmd_file_path}{the path the to .Rmd file.}

\item{polished_config_args}{arguments to be passed to \code{\link{polished_config}}.
(\strong{NOTE:} Values passed in this list will override YAML header values if both provided).}

\item{sign_in_page_args}{a named \code{list()} to customize the Sign In page
UI. Valid names are \code{color}, \code{company_name}, \code{logo}, & \code{background_image}.
(\strong{NOTE:} Values passed in this list will override YAML header values if both provided).}

\item{sign_out_button}{A \code{shiny::actionButton} or \code{shiny::actionLink} with \code{inputId = "sign_out"}.
If this argument is left as \code{NULL}, \code{secure_rmd} will attempt to add in an appropriate sign
out button/link depending on the output format of your .Rmd document.  Set this argument to \code{list()}
to not include a sign out button.}
}
\value{
a Shiny app object
}
\description{
\code{secure_rmd()} can be used to render (or run) and secure many
types of R Markdown documents. Rendering is handled either by \code{rmarkdown::render}
or, if using \code{shiny}, a \code{shiny} app is constructed, and the then
the output is secured with \code{polished} authentication.
}
\examples{

\dontrun{

secure_rmd(system.file("examples/rmds/flexdashboard.Rmd", package = "polished"))
secure_rmd(
  system.file("examples/rmds/flexdashboard.Rmd", package = "polished"),
  polished_config_args = list(
    # any values in this list will override values in YAML header
    app_name = "different_name"
  ),
  sign_in_page_args = list(
    color = "#FF5700"
  )
)
secure_rmd(system.file("examples/rmds/flexdashboard_shiny.Rmd", package = "polished"))
secure_rmd(system.file("examples/rmds/html_document.Rmd", package = "polished"))
secure_rmd(system.file("examples/rmds/pdf_document.Rmd", package = "polished"))
io_file_path <- system.file(
  "examples/rmds/ioslides/ioslides_presentation.Rmd",
  package = "polished"
)
secure_rmd(io_file_path)
}
}
