#' States dataset for R Companion to Essentials of Political Analysis
#'
#' A dataset with variables about the 50 states. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A data frame with 50 rows and 135 variables.
#' @source Sources vary.  See book Appendix for further information.
"states"


#' World dataset for R Companion to Essentials of Political Analysis
#'
#' A dataset with variables about countries in the world. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A data frame with 167 rows and 103 variables.
#' @source Sources vary.  See book Appendix for further information.
"world"


#' GSS dataset for R Companion to Essentials of Political Analysis
#'
#' The General Social Survey polls individuals about their attitudes and beliefs. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A data frame with 1974 rows and 221 variables.
#' @source Sources vary.  See book Appendix for further information.
"gss"


#' NES dataset for R Companion to Essentials of Political Analysis
#'
#' The American National Election Survey polls individuals about their political beliefs and behavior. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A data frame with 5916 rows and 399 variables.
#' @source Sources vary.  See book Appendix for further information.
"nes"


#' States design dataset for R Companion to Essentials of Political Analysis
#'
#' This is a design dataset with variables about the 50 states. This design dataset is used to demonstrate application of certain R functions to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A survey.design object.  The variables element has 50 observations of 135 variables.
#' @source Sources vary.  See book Appendix for further information.
"statesD"


#' World design dataset for R Companion to Essentials of Political Analysis
#'
#' This is a design dataset with variables about countries in the world. This dataset is used to demonstrate application of R to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A survey.design object.  The variables element has 167 observations of 103 variables.
#' @source Sources vary.  See book Appendix for further information.
"worldD"


#' GSS design dataset for R Companion to Essentials of Political Analysis
#'
#' The General Social Survey polls individuals about their attitudes and beliefs. This design dataset is used to demonstrate application of certain R functions to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A survey.design object.   The variables element has 1974 observations of 221 variables.
#' @source Sources vary.  See book Appendix for further information.
"gssD"


#' NES design dataset for R Companion to Essentials of Political Analysis
#'
#' The American National Election Survey polls individuals about their political beliefs and behavior. This design dataset is used to demonstrate application of certain R functions to political analysis. See book Appendix for variable names and descriptions.
#'
#' @format A survey.design object.   The variables element has 5916 observations of 399 variables.
#' @source Sources vary.  See book Appendix for further information.
"nesD"

