% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/draft_validation.R
\name{draft_validation}
\alias{draft_validation}
\title{Draft a starter \strong{pointblank} validation .R/.Rmd file with a data table}
\usage{
draft_validation(
  tbl,
  tbl_name = NULL,
  file_name = tbl_name,
  path = NULL,
  lang = NULL,
  output_type = c("R", "Rmd"),
  add_comments = TRUE,
  overwrite = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{tbl}{The input table. This can be a data frame, tibble, a \code{tbl_dbi}
object, or a \code{tbl_spark} object.}

\item{tbl_name}{A optional name to assign to the input table object. If no
value is provided, a name will be generated based on whatever information
is available. This table name will be displayed in the header area of the
agent report generated by printing the \emph{agent} or calling
\code{\link[=get_agent_report]{get_agent_report()}}.}

\item{file_name}{An optional name for the .R or .Rmd file. This should be a
name without an extension. By default, this is taken from the \code{tbl_name}
but if nothing is supplied for that, the name will contain the text
\code{"draft_validation_"} followed by the current date and time.}

\item{path}{A path can be specified here if there shouldn't be an attempt to
place the generated file in the working directory.}

\item{lang}{The language to use when creating comments for the automatically-
generated validation steps. By default, \code{NULL} will create English (\code{"en"})
text. Other options include French (\code{"fr"}), German (\code{"de"}), Italian
(\code{"it"}), Spanish (\code{"es"}), Portuguese (\code{"pt"}), Turkish (\code{"tr"}), Chinese
(\code{"zh"}), Russian (\code{"ru"}), Polish (\code{"pl"}), Danish (\code{"da"}), Swedish
(\code{"sv"}), and Dutch (\code{"nl"}).}

\item{output_type}{An option for choosing what type of output should be
generated. By default, this is an .R script (\code{"R"}) but this could
alternatively be an R Markdown document (\code{"Rmd"}).}

\item{add_comments}{Should there be comments that explain the features of the
validation plan in the generated document? By default, this is \code{TRUE}.}

\item{overwrite}{Should a file of the same name be overwritten? By default,
this is \code{FALSE}.}

\item{quiet}{Should the function \emph{not} inform when the file is written? By
default this is \code{FALSE}.}
}
\value{
Invisibly returns \code{TRUE} if the file has been written.
}
\description{
Generate a draft validation plan in a new .R or .Rmd file using an input data
table. Using this workflow, the data table will be scanned to learn about its
column data and a set of starter validation steps (constituting a validation
plan) will be written. It's best to use a data extract that contains at least
1000 rows and is relatively free of spurious data.

Once in the file, it's possible to tweak the validation steps to better fit
the expectations to the particular domain. While column inference is used to
generate reasonable validation plans, it is difficult to infer the acceptable
values without domain expertise. However, using \code{draft_validation()} could
get you started on floor 10 of tackling data quality issues and is in any
case better than starting with an empty code editor view.
}
\section{Function ID}{

1-11
}

\examples{
if (interactive()) {

# Draft validation plan for the
# `dplyr::storms` dataset
draft_validation(tbl = dplyr::storms)

}

}
\seealso{
Other Planning and Prep: 
\code{\link{action_levels}()},
\code{\link{create_agent}()},
\code{\link{create_informant}()},
\code{\link{db_tbl}()},
\code{\link{file_tbl}()},
\code{\link{scan_data}()},
\code{\link{tbl_get}()},
\code{\link{tbl_source}()},
\code{\link{tbl_store}()},
\code{\link{validate_rmd}()}
}
\concept{Planning and Prep}
