% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data_extracts.R
\name{get_data_extracts}
\alias{get_data_extracts}
\title{Collect data extracts from a validation step}
\usage{
get_data_extracts(agent, i = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}. It should have had
\code{\link[=interrogate]{interrogate()}} called on it, such that the validation steps were carried
out and any sample rows from non-passing validations could potentially be
available in the object.}

\item{i}{The validation step number, which is assigned to each validation
step in the order of definition.}
}
\value{
A list of tibbles if \code{i} is not provided, or, a tibble if \code{i} is
given.
}
\description{
Get data that didn't pass a validation step. The amount of data available in
a particular extract depends on both the fraction of validation units that
didn't pass a validation step and the level of sampling or explicit
collection from that set of units (this is defined within the \code{\link[=interrogate]{interrogate()}}
call).
}
\section{Function ID}{

3-4
}

\examples{
library(dplyr)

# Create a simple table with a
# column of numerical values
tbl <- tibble(a = c(5, 7, 8, 5))

# Create 2 simple validation steps
# that test whether values within
# column `a`
agent <-
  create_agent(tbl = tbl) \%>\%
  col_vals_between(vars(a), 4, 6) \%>\%
  col_vals_lte(vars(a), 7) \%>\%
  interrogate(
    extract_failed = TRUE,
    get_first_n = 10
  )

# Get row sample data for those rows
# in `tbl` that did not pass the first
# validation step (`col_vals_between`)
agent \%>\% get_data_extracts(i = 1)

}
\seealso{
Other Interrogate and Get Info: 
\code{\link{all_passed}()},
\code{\link{get_agent_report}()},
\code{\link{interrogate}()}
}
\concept{Interrogate and Get Info}
