% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/pointer.norm.R
\name{pointer.norm}
\alias{pointer.norm}
\title{Calculate pointer years using the normalization in a moving window method}
\usage{
pointer.norm(data, window = 5, method.thresh = c("Cropper", "Neuwirth"),
             C.thresh = 0.75, N.thresh1 = 1, N.thresh2 = 1.28,
             N.thresh3 = 1.645, series.thresh = 40)
}
\arguments{
\item{data}{a \code{data.frame} with tree-ring series as columns and years as rows (e.g., output of \code{read.rwl} of package dplR)}

\item{window}{an \code{integer} specifying the window size (i.e. number of years) to be used to calculate normalized growth deviations. Defaults to 5.}

\item{method.thresh}{a \code{character} string of \code{"Cropper"} or \code{"Neuwirth"}, specifying the method to be used to calculate event years. Argument matching is performed.}

\item{C.thresh}{a \code{numeric} specifying the threshold for identification of event years using method \code{"Cropper"}. Defaults to 0.75.}

\item{N.thresh1}{a \code{numeric} specifying the threshold for identification of weak event years using method \code{"Neuwirth"}. Defaults to 1.}

\item{N.thresh2}{a \code{numeric} specifying the threshold for identification of strong event years using method \code{"Neuwirth"}. Defaults to 1.28.}

\item{N.thresh3}{a \code{numeric} specifying the threshold for identification of extreme event years using method \code{"Neuwirth"}. Defaults to 1.645.}

\item{series.thresh}{a \code{numeric} specifying the minimum percentage of trees that should display a positive (or negative) event year for that year to be considered as positive (or negative) pointer year. Defaults to 40.}
}
\value{
The function returns a \code{list} containing the following components:

\itemize{\item{for method \code{"Cropper"}:}}
\item{Cvalues}{a \code{matrix} with Cropper values for individual tree-ring series}
\item{EYvalues}{a \code{matrix} indicating positive (1), negative (-1) and non-event years (0) for individual tree-ring series}
\item{out}{a \code{data.frame} containing the following columns:}
\item{}{\code{year} - time stamp}
\item{}{\code{nb.series} - number of series considered}
\item{}{\code{perc.pos} - percentage of trees showing a positive event year}
\item{}{\code{perc.neg} - percentage of trees showing a negative event year}
\item{}{\code{nature} - number indicating whether the year is a positive (1), negative (-1) or no pointer year (0)}
\item{}{\code{Cvalues_mean} - mean Cropper value over the available series}
\item{}{\code{Cvalues_sd} - standard deviation of Cropper values}
\item{spec.param}{a \code{data.frame} specifying the arguments used in the calculation}

\itemize{\item{for method \code{"Neuwirth"}:}}
\item{Cvalues}{a \code{matrix} with Cropper values for individual tree-ring series}
\item{EYvalues}{a \code{matrix} indicating weak (1/-1), strong (2/-2) and extreme (3/-3) positive/negative event years, as well as non-event years (0) for individual tree-ring series}
\item{out}{a \code{data.frame} containing the following columns:}
\item{}{\code{year} - time stamp}
\item{}{\code{nb.series} - number of series considered}
\item{}{\code{perc.pos.extreme} - percentage of trees showing a positive extreme event year}
\item{}{\code{perc.pos.strong} - percentage of trees showing a positive strong event year}
\item{}{\code{perc.pos.weak} - percentage of trees showing a positive weak event year}
\item{}{\code{perc.neg.weak} - percentage of trees showing a negative weak event year}
\item{}{\code{perc.neg.strong} - percentage of trees showing a negative strong event year}
\item{}{\code{perc.neg.extreme} - percentage of trees showing a negative extreme event year}
\item{}{\code{nature} - number indicating whether the year is a positive (1), negative (-1) or no pointer year (0)}
\item{}{\code{Cvalues_mean} - mean Cropper value over the available series}
\item{}{\code{Cvalues_sd} - standard deviation of Cropper values}
\item{spec.param}{a \code{data.frame} specifying the arguments used in the calculation}
}
\description{
The function calculates pointer years on a \code{data.frame} of tree-ring series using the normalization in a moving window method introduced by Cropper (1979; cf. Schweingruber et al. 1990). This method normalizes tree growth in year \code{\var{i}} within a moving window of \code{\var{n}} years, thereby providing the number of standard deviations that tree growth deviates in individual years (Cropper values, C). To identify event years, thresholds on the number of standard deviations can be set according to Cropper (1979) and Neuwirth et al. (2007), optionally with different threshold values. The threshold for defining pointer years can be adjusted.
}
\details{
The function normalizes tree growth in year \code{\var{i}} within a moving window of \code{\var{n}} years. For method \code{"Cropper"}, event years are defined as those years having absolute Cropper values above a specified threshold (defaults to |C| > 0.75). For method \code{"Neuwirth"}, three classes of distinct growth deviations can be defined, being 'weak', 'strong' and 'extreme' (defaults to |C| > 1, |C| > 1.28, and |C| > 1.645). The window size can be adjusted, as well as the minimum percentage of trees that should display a positive (or negative) event year for that year to be considered as positive (or negative) pointer year.

Note that the resulting time series are truncated by \code{\var{(window-1)/2}} at both ends inherent to the calculation methods.
}
\examples{
## Calculate pointer years on tree-ring series using the method "Cropper"
## and a user-defined threshold for event-year definition of 1:
data(s033)
py_c <- pointer.norm(s033, window = 5, method.thresh = "Cropper",
                     C.thresh = 1, series.thresh = 40)
py_c$out

## Calculate pointer years on tree-ring series using the method "Neuwirth"
## and a moving window of 13 years:
data(s033)
py_n <- pointer.norm(s033, window = 13, method.thresh = "Neuwirth",
                     series.thresh = 40)
py_n$out
}
\author{
Marieke van der Maaten-Theunissen and Ernst van der Maaten.
}
\references{
Cropper, J.P. (1979) Tree-ring skeleton plotting by computer. \emph{Tree-Ring Bulletin} 39: 47-59.

Neuwirth, B., Schweingruber, F.H. and Winiger, M. (2007) Spatial patterns of central European pointer years from 1901 to 1971. \emph{Dendrochronologia} 24: 79-89.

Schweingruber, F.H., Eckstein, D., Serre-Bachet, F. and Bräker, O.U. (1990) Identification, presentation and interpretation of even years and pointer years in dendrochronology. \emph{Dendrochronologia} 8: 9-38.
}

