% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conn_podr.R
\name{conn_podr}
\alias{conn_podr}
\title{Make a connection to PHUSE Open Data Repository (PODR)}
\usage{
conn_podr(
  username = NULL,
  userpwd = NULL,
  driver = "postgresql",
  server = "podr.phuse.global",
  port = "5432",
  database = "nihpo"
)
}
\arguments{
\item{username}{provides user name for PODR database connection given as a character string}

\item{userpwd}{provides user password for PODR user given as a character string}

\item{driver}{is database driver defaults to "postgresql"}

\item{server}{is server name in FQDN or IP address defaults to "podr.phuse.global"}

\item{port}{is port number defaults to "5432"}

\item{database}{is database name defaults to "nihpo"}
}
\value{
Nothing - sets the 'podr_connection' option
}
\description{
This function will set a PODR connection within the 'podr_connection'
option. Ideally, you shouldn't need to worry about this after it's set.
Using the read_podr function will utilize the connection automatically
by default.
}
\details{
You will be prompted within the RStudio interface for your user name and password
if you did not provides when setting the connection,
}
\examples{
\dontrun{
  conn_podr()   # require user to provide name and password interactively
  conn_podr('my_username','my_pwd')
}

}
\author{
Hanming Tu
}
