\name{pocrm.imp}
\alias{pocrm.imp}

\title{
Executing the PO-CRM
}
\description{
pocrm.imp is used to compute a combination recommendation for the next patient in a Phase I trial of combined drugs according to the partial order continual reassessment method (PO-CRM).
}
\usage{
pocrm.imp(alpha, prior.o, theta, y, combos)
}

\arguments{
  \item{alpha}{
A matrix of skeleton values corresponding to the possible orderings of the toxicity probabilities generated by getwm.
}
  \item{prior.o}{
A vector of prior probabilities on the orderings.
}
  \item{theta}{
The target DLT rate.
}
  \item{y}{
A vector of patient outcomes; 1 indicates toxicity, 0 otherwise.
}
  \item{combos}{
A vector of dose levels assigned to patients. The length of combos must be equal to y.
}
}
\details{
The method bases toxicity probability estimates on the power model (2) of Wages, Conaway and O'Quigley (2011).
}
\value{
  \item{order.est}{
Updated estimate of the ordering of toxicity probabilities.
}
  \item{a.est}{
The estimate of the model parameter.
}
  \item{ptox.est}{
Updated estimates of the toxicity probabilities.
}
  \item{dose.rec}{
The combination recommended for the next patient cohort.
}
}
\references{
Wages, Conaway and O'Quigley (2011). Dose-finding design for multi-drug combinations. Clinical Trials 8(4): 380-389.
}

\examples{

#All specifications refer to example in Wages, Conaway and O'Quigley (2011).

#Specify the possible orderings from Table 2
orders<-matrix(nrow=8,ncol=8)
orders[1,]<-c(1,2,3,4,5,6,7,8)
orders[2,]<-c(1,3,2,4,5,6,7,8)
orders[3,]<-c(1,2,3,5,4,6,7,8)
orders[4,]<-c(1,2,3,4,5,7,6,8)
orders[5,]<-c(1,3,2,5,4,6,7,8)
orders[6,]<-c(1,3,2,4,5,7,6,8)
orders[7,]<-c(1,2,3,5,4,7,6,8)
orders[8,]<-c(1,3,2,5,4,7,6,8)

#Specify the skeleton values provided in Table 4.
skeleton<-c(0.01,0.03,0.10,0.20,0.33,0.47,0.60,0.70)

#Initial guesses of toxicity probabilities for each ordering.
alpha<-getwm(orders,skeleton)

#We consider all orders to be equally likely prior to the study.
prior.o<-rep(1/8,8)

#The target toxicity rate
theta<-0.20

#Combinations tried on the first 11 patients in Table 5.
combos<-c(2,3,5,4,7,5,4,3,2,2,3)

#Toxicity outcomes on the first 11 patients in Table 5.
y<-c(0,0,0,0,1,1,1,0,0,1,1)

fit<-pocrm.imp(alpha,prior.o,theta,y,combos)
fit
}
